/************************************************************************/
/*                                                                      */
/*    This example demonstrates how to use stream calculation to obtain */
/*    the chill factors in the steelmaking industry.[1]                 */
/*                                                                      */
/*    [1] O.Kubaschewski and C.B. Alock, Metellurgical Thermochemistry, */
/*        1979, Page 211.                                               */
/*                                                                      */
/************************************************************************/

#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
main(int argc, char *argv)
{

  TC_INT *iwsg,*iwse;
  TC_STRING file;
  TC_INT ierr,ipl,ic,ips,inu;
  TC_FLOAT tliq_fe,val,dt;
  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];
  char* str;

  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  file=malloc(TC_STRLEN_MAX);
  str=malloc(TC_STRLEN_MAX);

  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));

  /* initializing */
  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);

  /* read thermodynamic data from a GES file */
  fprintf(stdout,"Thermodynamic data file /TQEX06/:");
  fgets(file,TC_STRLEN_MAX,stdin);
  if ( file[0] == 10) { strcpy(file,"TQEX06.GES5"); }
  tq_rfil(file,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"Failed to open the data file! %d\n",ierr);
    return;
  }

  /* change temperature unit to C */
  tq_ssu("T","C",iwsg,iwse);


  /* create a stream named LIQUID_FE and input Fe liquid at the 1600 C */
  /* and one atmosphere */
  tliq_fe=1600.;
  tq_cstm("LIQUID_FE",tliq_fe,1.0e5,iwsg,iwse);
  if (tq_sg2err(&ierr)) { return; }

  /* get the index of the liquid phase. */
  tq_gpi(&ipl,"LIQUID",iwsg,iwse);
  if (tq_sg2err(&ierr)) { return; }

  /* get the index of the consitituent Fe in the liquid phase */
  tq_gpci(ipl,&ic,"FE",iwsg,iwse);
  if (tq_sg2err(&ierr)) { return; }

  /* set the amount of Fe in the stream to 49 mole */
  tq_ssc("LIQUID_FE",ipl,ic,49.0,0,iwsg,iwse);
  if (tq_sg2err(&ierr)) { return; }

  /* create another stream named MASTER_FESI and input Fe1Si1 at the room */
  /* temperature and one atmosphere */

  tq_cstm("MASTER_FESI",25.0,1.0e5,iwsg,iwse);
  if (tq_sg2err(&ierr)) { return; }

  /* get the index of the master alloy FE1SI1_S phase. */
  tq_gpi(&ips,"FE1SI1_S",iwsg,iwse);
  if (tq_sg2err(&ierr)) { return; }

  /* set the amount of FE1SI1 in the stream to 1 mole */
  tq_ssc("MASTER_FESI",ips,1,1.0,0,iwsg,iwse);
  if (tq_sg2err(&ierr)) { return; }

  /* set the reaction pressure */
  tq_setc("p",-1,-1,1.e5,&inu,iwsg,iwse);

  /* specify the invariant state variable for the reaction calculation */
  tq_ssic("HD",0.0,iwsg,iwse);

  /* make an estimation of the result temperature, if you can */
  tq_ce("T",0,0,1500.0,iwsg,iwse);

  /* get the temperature */
  tq_get1("T",-1,-1,&val,iwsg,iwse);
  dt=val-tliq_fe;

  fprintf(stdout,"DT = %f\n",dt);

  tq_get1("X",-1,2,&val,iwsg,iwse);
  fprintf(stdout,"The comp. of the final solution is %f at percent Si\n",val);

  tq_get1("DG",ips,-1,&val,iwsg,iwse);
  if (val < 0.0) {
    fprintf(stdout,"The FE1SI1_S phase should not be stable !\n"); }
  else {
    fprintf(stdout,"Strange, FE1SI1_S phase is still stable !\n"); }


  /* set the amount of Fe in the stream to 98 mole */
  tq_ssc("LIQUID_FE",ipl,ic,98.0,0,iwsg,iwse);

  /* make a estimation of the result temperature, if you can */
  tq_ce("T",0,0,1500.0,iwsg,iwse);

  /* get the temperature */
  tq_get1("T",-1,-1,&val,iwsg,iwse);
  dt=val-tliq_fe;

  fprintf(stdout,"DT = %f\n",dt);

  tq_get1("X",-1,2,&val,iwsg,iwse);
  fprintf(stdout,"The comp. of the final solution is %f at percent Si\n",val);

  tq_get1("DG",ips,-1,&val,iwsg,iwse);
  if (val < 0.0) {
    fprintf(stdout,"The FE1SI1_S phase should not be stable !\n"); }
  else {
    fprintf(stdout,"Strange, FE1SI1_S phase is still stable !\n"); }
  
  free(str);
  free(file);
  free(iwsg);
  free(iwse);
}
