#!/bin/bash
#set -x
listOfExamples="tqex01
tqex02
tqex03
tqex04
tqex05
tqex06
tqex07
tqex08
tqex09
tqex10
tqex11
tqex12
tqex13
tqex14
tqex15"

START="${PWD}"
ROOT="$(dirname "${PWD}/${BASH_SOURCE}")"
TQ_LIB=gfortran

for example in ${listOfExamples}
do
 cd "${ROOT}/${example}"
 echo $PWD
 echo -n "Compiling ${example}.f"
 make -s TQ_LIB_VERSION="${TQ_LIB}"
 echo " compiling done."
 echo "Starting ${example}"
 top_in="${ROOT}/../../source/Fortran/${example}.in"
 local_in="${example}.in"
 if [ -f "${top_in}" ];
 then
    ./"${example}" < "${top_in}"
 else
    if [ -f "${local_in}" ];
    then
       ./"${example}" < "${local_in}"
    else
       ./"${example}"
    fi
 fi
 echo -e "\n${example} done\n\n\n"
done
cd "${START}"
