C/************************************************************************/
C/*                                                                      */
C/*    This sample program demonstrates that the number of phases can    */
C/*    increase due to the use of global mininization for equilibrium    */
C/*    calculation during which additional composition set(s) can be     */
C/*    added automatically if a miscibility gap is detected.             */
C/*                                                                      */
C/************************************************************************/

      program tqex13

      implicit double precision (a-h,o-z)
      double precision P,N
      parameter (nwsg=80000,nwse=500000)
      dimension iwsg(nwsg)
      dimension iwse(nwse)
      CHARACTER*256 TCPATH,TMPPATH
      character*32 phas1,pname(200)
      logical tqg2err
C     
      WRITE(*,1)
 1    FORMAT(
     &' '/
     &'This is a part of the source code samples demonstrating the use'/
     &'of the Thermodynamic calCUlation interface (TQ) for Thermo-Calc'/
     &' '/
     &'This sample program demonstrates that the number of phases can'/
     &'increase due to the use of global mininization for equilibrium'/
     &'calculation during which additional composition set(s) can be'/
     &'added automatically if a miscibility gap is detected.'/
     &' '/)

c...  initiate workspace
      tcpath=' '
      tmppath=' '
      CALL GET_ENVIRONMENT_VARIABLE('TC24B_HOME',tcpath)
C...  use the default temporary directory
      tmppath=' '
      CALL TQINI3(tcpath,tmppath,NWSG,NWSE,IWSG,IWSE)
      if(tqg2err(ierr)) then
	 print *, 'Cannot initialize the Thermo-Calc workspace!'
	 stop
      endif

c...  open database FEDEMO

      call tqopdb('FEDEMO',iwsg,iwse)
      if(tqg2err(ierr)) then
         print *, 'Database or database license not available!'
         stop
      endif

c...  define element Fe

      call tqdefel('Fe',iwsg,iwse)
      if(tqg2err(ierr)) then
         print *, 'Error in defining element Fe!'
         stop
      endif

c...  define element Cr

      call tqdefel('Cr',iwsg,iwse)
      if(tqg2err(ierr)) then
         print *, 'Error in defining element Cr!'
         stop
      endif

c...  get data from the database

      call tqgdat(iwsg,iwse)
      if(tqg2err(ierr)) then
         print *, 'Error in getting data from the database!'
         stop
      endif

c...  print phase names and their index
c...  note no 2nd composition set added manually for BCC phase

      call prphase(iwsg,iwse)

c...  set conditions

      P=101325.d0
      N=1.0D0
      xFCR=0.5d0
      call tqsetc('P',-1,-1, P ,numcon,iwsg,iwse)
      call tqsetc('N', 0, 0, N ,numcon,iwsg,iwse)
      call tqgsci(icmp2,'CR',iwsg,iwse)
      call tqsetc('X',-1,icmp2,xFCR,numcon,iwsg,iwse)

c...  make calculations at 1000 K, where there should
c...  be no miscibility gap exsiting. As a result, normal
c...  calculation and global one should give same result.

      T=1000.D0
      call tqsetc('T',-1,-1, T ,numcon,iwsg,iwse)
      call tqce(' ', 0, 0, 0.d0,iwsg,iwse)
      if(tqg2err(ierr)) then
         print *, 'Error in calculating phase equilibrium!'
         stop
      endif

c...  open the screen output unit and list equilibrium result
c...  correct equilibbrium obtained.

      call tqsio('output',6)
      call tqle(iwsg,iwse)

c...  print phase names and their index
c...  nothing changed

      call prphase(iwsg,iwse)

c...  try global minimization

      call tqceg(iwsg,iwse)
      if(tqg2err(ierr)) then
         print *, 'Error in calculating phase equilibrium!'
         stop
      endif

c...  list equilibrium result, which is the same as before

      call tqle(iwsg,iwse)

c...  print phase names and their index. nothing changed

      call prphase(iwsg,iwse)

c...  make calculations at 500 K, where BCC should split into
c...  two BCC phases, one rich in Fe, and the other in Cr.
c...  normal calculation will end up with a metastable equilibrium
c...  because no 2nd composition set predefined.
c...  global minimization algorithm can automatically generate
c...  this 2nd composition set if found necessary and hence
c...  garantee that the stable equilibrium will be obtained.

      T=500.D0
      call tqsetc('T',-1,-1, T ,numcon,iwsg,iwse)
      call tqce(' ', 0, 0, 0.d0, iwsg,iwse)

c...  list result. a metastable equilibrium instead stable equilibrium
c...  is obtained

      call tqle(iwsg,iwse)

c...  print phase names and their index. nothing changed

      call prphase(iwsg,iwse)

c...  try global and list calculation result. the stable 
c...  equilibrium is obtained.

      call tqceg(iwsg,iwse)
      call tqle(iwsg,iwse)

c...  print phase names and their index.
c...  number of system phases increased by one due to the
c...  appearance of BCC#2. note his "new" phase is added
c...  to the bottom of the list and the index of "old" phases
c...  is unaltered.

      call prphase(iwsg,iwse)

 900  continue
      end


      subroutine prphase(iwsg,iwse)
      implicit double precision (a-h,o-z)
      dimension iwsg(*),iwse(*)
      character*32 phas1
      
      print *,''
      call tqgnp(npha,iwsg,iwse)
      print 1010, 'number of phases : ', npha
 1010 format(1X,A,I3)
      do i=1,npha
         call tqgpn(i,phas1,iwsg,iwse)
         print 1020, 'index of ', phas1,' is ', i
 1020    format(1X,A,A,A,I3)
      enddo

      return
      end
