C/************************************************************************/
C/*                                                                      */
C/*    This sample program demonstrates how to use subroutines getting   */
C/*    system data from a database and how to restart new calculation    */
C/*    on a different system in the same application program             */
C/*                                                                      */
C/************************************************************************/

      PROGRAM TQEX12

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NWG=80000,NWP=500000,NC=20,ZERO=0.0D0)
      DIMENSION IWSG(NWG),IWSE(NWP)
      CHARACTER*256 TCPATH,TMPPATH
	CHARACTER*24 TDB(250),ENAME(200),DBNAME
	CHARACTER*24 PNAME(100),NAME
	CHARACTER*2 EL1,EL2
	CHARACTER*8 SNAME
	CHARACTER*1 YES
	DOUBLE PRECISION N,P,T,X2
	
	LOGICAL TQG2ERR

      WRITE(*,1)
 1    FORMAT(
     &' '/
     &'This is a part of the source code samples demonstrating the use'/
     &'of the Thermodynamic calCUlation interface (TQ) for Thermo-Calc'/
     &' '/
     &'This sample program demonstrates how to use subroutines getting'/
     &'system data from a database and how to restart new calculation'/
     &'on a different system in the same application program.'/
     &' '/)

C...initializing
      tcpath=' '
      tmppath=' '
      CALL GET_ENVIRONMENT_VARIABLE('TC24B_HOME',tcpath)
C... use the default temporary directory
      tmppath=' '
      CALL TQINI3(tcpath,tmppath,NWG,NWP,IWSG,IWSE)
10	FORMAT(1X,A,$)
20    FORMAT(A)	
60	CALL TQREJSY(IWSG,IWSE)
	IF(TQG2ERR(IERR)) THEN
		WRITE(6,*) 'ERROR IN REJECTING DEFINED SYSTEM!'
		STOP
	ENDIF
	CALL TQGDBN(TDB,ND,IWSG,IWSE)
	IF(TQG2ERR(IERR)) THEN
		WRITE(6,*) 'ERROR IN GETTING DATABASE LIST!'
		STOP
	ELSE
	    WRITE(6,*) 'AVAILABLE DATABASE: '
            i=1
 80         if (i.le.nd) then
               write(6,1010)(tdb(j)(1:lens(tdb(j))),j=i,min(i+2,nd))
 1010          format(3(A24,1X))
               i=i+3
               goto 80
            endif
	ENDIF
100	WRITE(6,10) 'Select a database from above list: '
	READ(5,20) DBNAME
	CALL TQOPDB(DBNAME,IWSG,IWSE)
	IF(TQG2ERR(IERR)) THEN
		CALL TQRSERR
		WRITE(6,*) 'THERE IS NO SUCH DATABASE! TRY AGAIN.'
          GOTO 100
	ENDIF
	CALL TQLIDE(ENAME,NE,IWSG,IWSE)
	IF(TQG2ERR(IERR)) THEN
		WRITE(6,*) 'ERROR IN LISTING DATABASE ELEMENTS!'
		STOP
	ELSE
           WRITE(6,*) 'AVAILABLE DATABASE ELEMENTS: '
           i=1
 105       if (i.le.ne) then
              write(6,1010)(ename(j)(1:lens(ename(j))),j=i,min(i+2,ne))
              i=i+3
              goto 105
           endif
	ENDIF
110	WRITE(6,10) 'Select first element from above list: '
	READ(5,20) EL1
	CALL TQDEFEL(EL1,IWSG,IWSE)
	IF(TQG2ERR(IERR)) THEN
		CALL TQRSERR
		WRITE(6,*) 'THERE IS NO SUCH ELEMENT! TRY AGAIN.'
          GOTO 100
	ENDIF
120	WRITE(6,10) 'Select second element from above list: '
	READ(5,20) EL2
	CALL TQDEFEL(EL2,IWSG,IWSE)
	IF(TQG2ERR(IERR)) THEN
		CALL TQRSERR
		WRITE(6,*) 'THERE IS NO SUCH ELEMENT! TRY AGAIN.'
          GOTO 120
	ENDIF
	CALL TQLISPH(PNAME,NP,IWSG,IWSE)
	IF(TQG2ERR(IERR)) THEN
		WRITE(6,*) 'CANNOT LIST ALL SYSTEM PHASES IN THE DATABASE!'
		STOP
	ELSE
           WRITE(6,*) 'All phases for the system in the database: '
           i=1
 125       if (i.le.np) then
              write(6,1010)(pname(j)(1:lens(pname(j))),j=i,min(i+2,np))
              i=i+3
              goto 125
           endif
	ENDIF
	CALL TQLISSF(PNAME,NP,IWSG,IWSE)
	IF(TQG2ERR(IERR)) THEN
           WRITE(6,*) 'CANNOT LIST SELECTED PHASES IN THE DATABASE!'
           STOP
	ELSE
           WRITE(6,*) 'Selected system phases: '
           i=1
 128       if (i.le.np) then
              write(6,1010)(pname(j)(1:lens(pname(j))),j=i,min(i+2,np))
              i=i+3
              goto 128
           endif
	ENDIF
130	WRITE(6,*)''
	WRITE(6,10)'Reject any phase(s)? /NONE/: '
	READ(5,20)NAME
	IF(LENS(NAME).GT.0.AND.NAME(1:4).NE.'NONE'.AND.
     &                          NAME(1:4).NE.'none') THEN
	    CALL TQREJPH(NAME,IWSG,IWSE)
	    IF(TQG2ERR(IERR)) THEN
               CALL TQRSERR
               WRITE(6,*)' CANNOT REJECT PHASE ',NAME
	    ENDIF
	    CALL TQLISSF(PNAME,NP,IWSG,IWSE)
	    IF(TQG2ERR(IERR)) THEN
               WRITE(6,*) 'CANNOT LIST PHASES IN THE DATABASE!'
               STOP
	    ELSE
               WRITE(6,*) 'Selected system phases: '
               i=1
 132           if (i.le.np) then
                  write(6,1010)(pname(j)(1:lens(pname(j))),
     &                 j=i,min(i+2,np))
                  i=i+3
                  goto 132
               endif
	    ENDIF
	    IF(INDEX(NAME,'*').LE.0) GOTO 130
	ENDIF
140	WRITE(6,*)''
	WRITE(6,10)'Restore any phase? /NONE/: '
	READ(5,20)NAME
	IF(LENS(NAME).GT.0.AND.NAME(1:4).NE.'NONE'.AND.
     &                          NAME(1:4).NE.'none') THEN
           CALL TQRESPH(NAME,IWSG,IWSE)
           IF(TQG2ERR(IERR)) THEN
              CALL TQRSERR
              WRITE(6,*)' CANNOT RESTORE PHASE ',NAME
           ENDIF
           CALL TQLISSF(PNAME,NP,IWSG,IWSE)
           IF(TQG2ERR(IERR)) THEN
              WRITE(6,*) 'CANNOT LIST PHASES IN THE DATABASE!'
              STOP
           ELSE
              WRITE(6,*) 'Selected system phases: '
              i=1
 142          if (i.le.np) then
                 write(6,1010)(pname(j)(1:lens(pname(j))),
     &                j=i,min(i+2,np))
                 i=i+3
                 goto 142
              endif
           ENDIF
           IF(INDEX(NAME,'*').LE.0) GOTO 140
	ENDIF

	CALL TQGDAT(IWSG,IWSE)
	IF(TQG2ERR(IERR)) THEN
		WRITE(6,*) 'CANNOT GET DATA FROM THE DATABASE! '
          STOP
	ENDIF

	P=1.D5
	T=1000.D0
	N=1.0D0
150	WRITE(6,*)''
	WRITE(6,10)'Mole fraction of the second element: '
	READ(5,*,ERR=910) X2
	IF(X2.GT.1.0) THEN
		WRITE(6,*)'MOLE FRACTION SHOULD BE LESS THAN 1.0!'
	    GOTO 150
	ENDIF
      CALL TQSETC('P',-1,-1,P,NCP,IWSG,IWSE)
      CALL TQSETC('T',-1,-1,T,NCT,IWSG,IWSE)
      CALL TQSETC('N',0,0,N,NCN,IWSG,IWSE)
      CALL TQGSCI(IEL2,EL2,IWSG,IWSE)
      CALL TQSETC('X',-1,IEL2,X2,NCX,IWSG,IWSE)
	CALL TQCEG(IWSG,IWSE)
	WRITE(6,*)' '
	CALL TQSIO('OUTPUT',6)
	CALL TQLE(IWSG,IWSE)
	WRITE(6,*)' '
	WRITE(6,10)'NEW CALCULATION ON A NEW SYSTEM? /Y OR N/: '
	READ(5,20)YES
	IF(YES.EQ.'Y'.OR.YES.EQ.'y') GOTO 60
	GOTO 990
910	WRITE(6,*)'NOT A NUMERICAL VALUE!'
990   CONTINUE
      END

