C/************************************************************************/
C/*                                                                      */
C/*    This sample program calculate the A3 temperature of a steel       */
C/*    and determine the influence of each alloying element on this      */
C/*    temperature. It demonstrates that some very special quantities,   */
C/*    such as the composition derivative of temperature, can be         */
C/*    obtained easily via the TQ interface.                             */
C/*                                                                      */
C/************************************************************************/

      PROGRAM TQEX07

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NWG=80000,NWP=500000,NC=6,ZERO=0.0D0)
      DIMENSION IWSG(NWG),IWSE(NWP),NCW(NC)
      DIMENSION TP(5),WP(NC),WPD(NC)
      character*256 tcpath,tmppath
      CHARACTER FILE*60,NCOM(NC)*2,ASK*60,DTDW*10
      LOGICAL SG1ERR, SG2ERR
      DATA WPD/0.3D0, 1.5D0, 97.3D0, 0.5D0, 0.1D0, 0.3D0/

      WRITE(*,1)
 1    FORMAT(
     &' '/
     &'This is a part of the source code samples demonstrating the use'/
     &'of the Thermodynamic calCUlation interface (TQ) for Thermo-Calc'/
     &' '/
     &'This example calculate the A3 temperature of a steel '/
     &'and determine the influence of each alloying element on this'/
     &'temperature. It demonstrates that some very special quantities,'/
     &'such as the composition derivative of temperature, can be '/
     &'obtained easily via the TQ interface.'/
     &' '/)

C...initializing
      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwg,nwp,iwsg,iwse)

10    FORMAT(1X,A,$)
20    FORMAT(A)

C...read thermodynamic data from a GES file
      WRITE(6,10)'Thermodynamic data file /TQEX07/: '
      READ(5,20)FILE
      IF(LENS(FILE).LE.0) FILE='TQEX07.GES5'
      CALL TQRFIL(FILE,IWSG,IWSE)
      IF(SG2ERR(IERR)) THEN
          WRITE(6,*)'Failed to open the data file!'
	  GOTO 900
      ENDIF

C...input of T and P
 100  WRITE(6,10)'Temperature (C) /1000/: '
      READ(5,*)TP(1)
      WRITE(6,10)'Pressure (bar) /100000/: '
      READ(5,*)TP(2)
C...input of composition of components, first the number of components
      CALL TQGCOM(NE,NCOM,IWSG,IWSE)
      IF(SG1ERR(IERR)) GOTO 900
      SUM=100
      DO 200 I=1,NE
          IF(NCOM(I).EQ.'FE') GOTO 200
          ASK='Weight percent of '//NCOM(I)
 150	  WRITE(6,10)ASK(1:LENS(ASK))//': '
	  READ(5,*)WP(I)
          IF(WP(I).GE.SUM) THEN
             WRITE(*,*)'Value out of limits'
             GOTO 150
          ELSEIF( WP(I).LE.0.0) THEN
              write(6,*) '*** Have a nice day! ***'
              GOTO 900
          ENDIF
          SUM=SUM-WP(I)
 200  CONTINUE

C...set equlibrium condition, P
      VAL=TP(2)
      CALL TQSETC('P',-1,-1,VAL,NCOND,IWSG,IWSE)
C...set equlibrium condition, N
      CALL TQSETC('N',-1,-1,1.0D0,NCOND,IWSG,IWSE)
C...set system composition, W
      DO 300 I=1,NE
         IF(NCOM(I).EQ.'FE') GOTO 300
         VAL=WP(I)
         CALL TQSETC('W%',-1,I,VAL,NCW(I),IWSG,IWSE)
 300  CONTINUE
C...set unit of temperature to Celsius degree
      CALL TQSSU('TEMP','C',IWSG,IWSE)
C...set equlibrium condition, T
 305  VALT=TP(1)
      CALL TQSETC('T',-1,-1,VALT,NCONT,IWSG,IWSE)
C...calculate equlibrium
      CALL TQCE(' ', 0, 0, 0.0D0, IWSG,IWSE)
C...calculate the A3 temperature by
C...first removing the temperature condition
      CALL TQREMC(NCONT,IWSG,IWSE)
C...then getting the bcc index and setting the amount to 0
      CALL TQGPI(IDP,'BCC',IWSG,IWSE)
      CALL TQCSP(IDP, 'FIXED', 0.0D0, IWSG,IWSE)
C...do a equilibrium calculation and get the A3 temperature
      CALL TQCE(' ', 0, 0, 0.0D0, IWSG,IWSE)
C...occasionally, it may be difficult get the calculation done. see
C...how we are going to handle this situation
      IF(SG2ERR(IERR)) THEN
          CALL RESERR
          CALL TQCE( ' ', 0, 0, 0.0D0, IWSG,IWSE)
          IF(SG2ERR(IERR)) THEN
              WRITE(*,*)'Sorry, try a reasonable starting temperature or
     &composition.'
              CALL RESERR
              CALL TQPINI(IWSG,IWSE)
              GOTO 100
          ENDIF
      ENDIF
      CALL TQGET1( 'T ', 0, 0, VALT, IWSG,IWSE)
      WRITE(*,1010)'The A3 temperature is calculated as ',VALT,' C'
 1010 format(1x,A,G15.5,A)
C...now we shall see how a small change of the alloy composition
C...can alter this temperature. This is obtained by getting a very
C...special quantity --- the derivative of this temperature with respect
C...to the content of an alloying element, i.e. T.W(A).
C...
      DO 400 I=1,NE
         IF(NCOM(I).EQ.'FE') GOTO 400
         DTDW='T.W('//NCOM(I)
         DTDW(LENS(DTDW)+1:)=')'
         CALL TQGET1(DTDW,-1,-1,VALD,IWSG,IWSE)
C...remember what we get is a value with respect to the mass fraction
C...in order to have the value refered to the mass percent, we should
C...devide the value by 100.
         VALD=VALD/100
         IF(VALD.GT.0) THEN
           WRITE(*,1020)'The A3 temperature increases ',ABS(VALD),' C wi
     &th 1% increase of ',NCOM(I)
         ELSE
           WRITE(*,1020)'The A3 temperature decreases ',ABS(VALD),' C wi
     &th 1% increase of ',NCOM(I)
         ENDIF
 1020 format(1x,A,G15.5,A,A)
 400  CONTINUE
C...if we want to decrease A3 temperature by 20 C, calculate how much
C...Mn we should add to the alloy
      VALT=VALT-20
      CALL TQSETC('T',-1,-1,VALT,NCONT,IWSG,IWSE)
      CALL TQGSCI(IMN,'MN',IWSG,IWSE)
      CALL TQREMC(NCW(IMN),IWSG,IWSE)
      CALL TQCE(' ',0,0,0.0D0,IWSG,IWSE)
      CALL TQGET1( 'W% ', 0, IMN, VALT, IWSG,IWSE)
      WRITE(*,1010)'A decrease of the A3 temperature by 20 C needs',
     &VALT-WP(IMN),'% more of Mn. '
      WRITE(*,*)'Let''s try another composition. A negative '//
     & 'input will terminate the program.'
      CALL TQPINI(IWSG,IWSE)
      GOTO 100
 900  CONTINUE
      END




