C/************************************************************************/
C/*                                                                      */
C/*    This sample program also simulate the non-equilibrium             */
C/*    solidification under the Scheil-Guilliver condition.              */
C/*                                                                      */
C/************************************************************************/
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      PROGRAM scheil
c For two phase, multicomponent solidification
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      INTEGER
     1  NUMCON, NOERR, NOERRX, ioS,
     2  i, nKomp, iKomp, nPhase, iPhase,
     %  liquid, solid

      DOUBLE PRECISION
     *  c0(10), cliq(10), cliq_eq(10), csol(10),
     *  cliqalt, dcliq, ac_liquid, ac_phase(30),
     *  T, Tliq, Tsol, dT, fsneu, dfl, Tstart,
     *  fracsol, dfs, fracsol_eq, Hliq, Hsol, dgm

      parameter (nwg=80000,nwp=500000)
      DIMENSION IWSG(nwg),IWSE(nwp)

      character*256 tcpath,tmppath
      CHARACTER
     *  Datei*50, namep*24

      LOGICAL SG1ERR,SG2ERR

          common//nKomp, nPhase, liquid, solid

c====================================================================c
c23456789012345678901234567890123456789012345678901234567890123456789012
c====================================================================c


      WRITE(*,1)
 1    FORMAT(
     &' '/
     &'This is a part of the source code samples demonstrating the use'/
     &'of the Thermodynamic calCUlation interface (TQ) for Thermo-Calc'/
     &' '/
     &'This sample program also simulate the non-equilibrium '/
     &'solidification under the Scheil-Guilliver condition.'/
     &' '/)

c Initialize and read datafile
      Datei = 'TQEX04'
      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwg,nwp,iwsg,iwse)
      if(sg2err(ierr)) write(*,*)ierr
      CALL SYSCPU(1,ICPU)
      CALL TQRFIL(Datei,IWSG,IWSE)
      open(20, file='scheil.out', iostat=ios)
      if(sg2err(ierr)) write(*,*)ierr
c Get number of components
      CALL TQGNC(nKomp,IWSG,IWSE)
      if(sg2err(ierr)) write(*,*)ierr
c Get number of phases 
      CALL TQGNP(nPhase, IWSG,IWSE)
      if(sg2err(ierr)) write(*,*)ierr
c Get the index of the liquid 
      call tqgpi( liquid, 'LIQ', IWSG,IWSE)
      if(sg2err(ierr)) then
         stop 'No liquid'
      endif
c Set units 
      CALL TQSSU('T ', 'C', IWSG,IWSE)
      CALL TQSSU('MASS ', 'gram', IWSG,IWSE)

c Set alloy composition  1=Al, 2=Mg, 3=Si
      c0(3) = 0.06
      c0(2) = 0.06
      iKomp=1
      c0(1) = 1. - c0(3) - c0(2)

c Set equilibrium conditions 
c Compute the liquidus temperature 
      do i=2, nKomp
            call tqsetc( 'X ', 0, i, c0(i), numcon, IWSG,IWSE)
      enddo
      call tqsetc( 'N ', 0, 0, 1.D0, numcon, IWSG,IWSE)
      call tqsetc( 'P ', 0, 0, 1.D5, numcon, IWSG,IWSE)

c first a calculation at fixed T at low T with little or no liquid
      call tqsetc( 'T ', 0, 0, 3000.D0, numt, IWSG,IWSE)
      call tqce(' ', 0, 0, 0.D0, IWSG,IWSE)
c calculate when the amount of liquid is 1 mole, i.e. liquidus
      call tqremc( numt, IWSG,IWSE)
      call tqcsp( liquid, 'fixed', 1.0D-0, IWSG,IWSE)
      call tqce( ' ', 0, 0, 0.D0, IWSG,IWSE)
      call tqget1( 'T ', 0, 0, Tliq, IWSG,IWSE)
c calculate when the amount of liquid is 0 mole but stable, i.e. solidus
      call tqcsp( liquid, 'fixed', 0.0D-0, IWSG,IWSE)
      call tqce( ' ', 0, 0, 0.D0, IWSG,IWSE)
      if(sg2err(ierr)) write(*,*)ierr
      call tqget1( 'T ', 0, 0, TSol, IWSG,IWSE)
      call tqcsp( liquid, 'entered', 1.0d0, IWSG,IWSE)
      ittt=Tliq+0.5
      Tstart=ittt
      call tqsetc( 'T ', 0, 0, Tstart, numt, IWSG,IWSE)
      call tqce( ' ', 0, 0, 0.D0, IWSG,IWSE)
      if(sg1err(ierr)) write(*,*)ierr
      call reserr
      Write(*,1010) ' Tliq = ', real( Tliq)
      Write(*,1010) ' Tsol = ', real( Tsol)
      Write(20,1010) ' # Tliq = ', real( Tliq)
      Write(20,1010) ' # Tsol = ', real( Tsol)
 1010 format(A,G15.5)

      T = Tliq
      fracsol = 0.0D0
      dT = 1.0D0
      fsneu = 0.D0

c Determine what solid phase will form by extracting the 
c driving forces
      dgmax=-1.0D2
      ii=0
      if(sg2err(ierr)) then
         write(*,*)ierr
         call reserr
      endif
 66   ii=ii+1
         if(ii.ne.liquid) then
            jj=ii
            indexc=0
            call tqget1( 'dg ', jj, indexc, dgm, IWSG,IWSE)
            if(sg1err(ierr)) call reserr
            if(dgm .gt. dgmax) then
               dgmax=dgm
               solid = ii
            endif
         endif
      if(ii.lt.nPhase) goto 66
 77   continue
C
      if(sg1err(ierr)) call reserr
      call tqgpn( solid, namep, IWSG,IWSE)
      write(*,*) namep, ' is the first solid phase to form'

c cliq should be set to the alloy composition 
      do i=2, nKomp
            cliq(i) = c0(i)
      enddo
      cliqalt = cliq(iKomp)
c The enthalpy of the system at the liquidus temperature
      if(sg1err(ierr)) call reserr
      call tqget1( 'HM ', 0, 0, Hliq, IWSG,IWSE)

      write(*,1010)' H(liq): ',Hliq
      WRITE(20,15)  Real(T), REAL (fracsol), REAL (0.),
     *                           REAL (cliqalt), REAL (cliqalt)
15    FORMAT( F8.2, F8.4, 3F8.4)

Ccccccccccccccccccccccccccccccc loop over the temperature
      fl=1.0D0
      DO 113 WHILE ( .TRUE. )
            Write(*,1020) T,fl,c0(2),c0(3)
 1020       format(4(G15.5,X))
c Exit the loop when two solid phases are stable
            i=0
 107        i=i+1
               jj=i
               if(jj.ne.liquid .and. jj.ne.solid) then
                  call tqget1( 'dg ', jj, 0, dgm, IWSG,IWSE)
                  if(dgm .eq. 0.0d0) then
                     call tqgpn( i, namep, IWSG,IWSE)
                     Write(*,*) 'A third phase is stable,'
                     Write(*,*) namep
                     Write(*,*) 'No three-phase equilibria'
                     goto 150
                  endif
               endif
C            enddo
            if(i.lt.nphase) goto 107
            T = T - dT
c Compute equilibrium at T with cliq as new alloy composition
            call tqsetc('T',0,0,T,numt,iwsg,iwse)
            call tqsetc('X',0,2,c0(2),numcon,iwsg,iwse)
            call tqsetc('X',0,3,c0(3),numcon,iwsg,iwse)
            call tqce(' ',0,0,0.0D0,iwsg,iwse)
C
            if(sg1err(ierr)) call reserr
C            call tqmon(iwsg,iwse)
            call tqget1('X',liquid,2,c0(2),iwsg,iwse)
            call tqget1('X',liquid,3,c0(3),iwsg,iwse)
            call tqget1('NP',liquid,0,dfl,iwsg,iwse)
            fl=fl*dfl
            fracsol=1.0-fl
c Results: fs as function of T
            WRITE(20,10)  Real(T), REAL (fracsol), c0(2), c0(3)
10              FORMAT( F8.2, F8.4, 3F8.4)
113    ENDDO
150   write(*,1010) 'Fraction primary phase', fracsol
c The enthalpy of the system at the solidus temperature
          call tqget1( 'HM ', 0, 0, Hsol, IWSG,IWSE)
          write(*,1010) ' delta Hmelt', Hliq - Hsol
          write(*,*)' Note: this include the enthalpy due to Cp'
C            call tqmon(iwsg,iwse)
      close(20)
      CALL SYSCPU(1,JCPU)
      write(0,1030)' Cpu time ',JCPU-ICPU
 1030 format(A,I3)
      END

c====================================================================c
c23456789012345678901234567890123456789012345678901234567890123456789012
c====================================================================c
c fuer die Komp. iKomp wird die Scheil-Gleichung berechnet
      subroutine get_eq(Temp, iKomp,
     *                  c0, cliq, csol, fracsol, ac_phase, IWSG,IWSE)

      integer
     * numcon, liquid, solid, nKomp, iKomp, nPhase, i

      double precision
     * fracsol, Temp, c0(10), cliq(10), csol(10),
     * fracliq, gliq, gsol, ac_liquid, ac_phase(30)

      DIMENSION IWSG(*),IWSE(*)

      common//nKomp, nPhase, liquid, solid

c Set the alloy composition
      do i=2, nKomp
            call tqsetc( 'X ', 0, i, c0(i), numcon, IWSG,IWSE)
      enddo

c Set the temperature, compute equilibrium and get the
c fraction solid
      call tqsetc( 'T ', 0, 0, Temp, numcon, IWSG,IWSE)
      call tqce( ' ', 0, 0, 0.0D0, IWSG,IWSE)
      call tqget1( 'NP ', liquid, 0, fracliq, IWSG,IWSE)
      fracsol = 1.D0 - fracliq

c Get the liquid composition
      do i=1, nKomp
            call tqget1( 'X ', liquid, i, cliq(i), IWSG,IWSE)
      enddo
c Get the solid composition
      do i=1, nKomp
            call tqget1( 'X ', solid, i, csol(i), IWSG,IWSE)
      enddo
c Aktivitaet aller Phasen
C      call tqget1( 'ac ', -1, 0, ac_phase, IWSG,IWSE)

      return
      end

