/************************************************************************/
/*                                                                      */
/*    This sample program does same thing as Example 9 except that it   */
/*    demonstrates how to convert mole fractions to                     */
/*    site fractions and first derivatives of Gm w.r.t. site fractions  */
/*    to that w.r.t. mole fractions. People feel comfortable            */
/*    with site fractions and first derivatives w.r.t. them may skip    */
/*    this example.                                                     */
/*                                                                      */
/************************************************************************/

#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
main(int argc, char *argv)
{

  TC_INT *iwsg,*iwse;
  TC_STRING gfile;
  TC_STRING str;
  TC_STRING phas;
  TC_FLOAT n;
  TC_INT i,j,ierr,iph;
  TC_FLOAT *tp,*amu;
  TC_FLOAT *as,*yf,*extra,*x;
  TC_INT* nscon;
  tc_components_strings *spname;
  TC_INT isp[3];

  TC_INT ne,ncnv,nc,*iwork;
  TC_FLOAT *work,*dgdy,*dgdx,gm;

  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];

#ifdef WIN32
  _set_output_format(_TWO_DIGIT_EXPONENT);
#endif


  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  gfile=malloc(TC_STRLEN_MAX);
  str=malloc(TC_STRLEN_MAX);
  phas=malloc(TC_STRLEN_PHASES);
  tp=malloc(2*sizeof(TC_FLOAT));
  spname=malloc(sizeof(tc_components_strings)*3);
  nscon=malloc(sizeof(TC_INT)*TC_MAX_NR_OF_SUBLATTICES);
  as=malloc(sizeof(TC_FLOAT)*TC_MAX_NR_OF_SUBLATTICES);
  yf=malloc(sizeof(TC_FLOAT)*TC_MAX_NR_OF_SUBLATTICES*TC_MAX_NR_OF_CONST_PER_SUBLATTICE);
  extra=malloc(sizeof(TC_FLOAT)*5);
  x=malloc(sizeof(TC_FLOAT)*TC_MAX_NR_OF_CONSTITUENTS);
  amu=malloc(sizeof(TC_FLOAT)*TC_MAX_NR_OF_CONSTITUENTS);
  dgdy=malloc(sizeof(TC_FLOAT)*TC_MAX_NR_OF_CONSTITUENTS);
  dgdx=malloc(sizeof(TC_FLOAT)*TC_MAX_NR_OF_CONSTITUENTS);
  iwork=malloc(sizeof(TC_INT)*4*TC_MAX_NR_OF_CONSTITUENTS);
  work=malloc(sizeof(TC_FLOAT)*2000);

  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));
  
  strcpy(phas,"FCC_A1");
  strcpy(spname[0].component,"C");
  strcpy(spname[1].component,"CR");
  strcpy(spname[2].component,"FE");

  /*   initialize */
  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);

  /*   read datafile */
  strcpy(gfile,"TQEX08.GES5");
  tq_rfil(gfile,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"Failed to open the data file! %d\n",ierr);
    return;
  }

  /*   get phase index */
  tq_gpi(&iph,phas,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"error %d in tqgpi \n",ierr);
    return;
  }

  /*   check if mobility data available */
  if ( !tq_cmobb(iph,iwsg,iwse) ) {
    fprintf(stdout,"No mobility data\n");
    return;
  }

  /*   input conditions */
  tp[0]=1000.0;
  tp[1]=101325.0;
  n=1.0;

  x[0]=1.e-2;
  x[1]=5.e-2;
  x[2]=1.0-x[0]-x[1];

  /*   convert mole fractions to y-fractions  */
  /*   note: only possible if no internal degree of freedom in the phase  */

  /*   get phase property */
  tq_gphp(iph,&ne,&ncnv,&nc,iwork,work,iwsg,iwse);

  /*   converting */
  tq_x2y(iph,ne,ncnv,nc,iwork,work,x,yf,iwsg,iwse);

  /*   input temperature and pressure        */
  tq_stp(tp,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"error %d in tqstp \n",ierr);
    return;
  }
  /*   input site fractions */
  tq_syf(iph,yf,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"error %d in tqsyf \n",ierr);
    return;
  }

  /*   get gibbs energy and its first derivatives wrt site fractions */
  tq_gmdy(iph,dgdy,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"error %d in tqgmdy \n",ierr);
    return;
  }

  /*   convert to first derivatives wrt mole fractions */
  tq_gmdx(iph,ne,ncnv,nc,iwork,work,yf,dgdy,
	  &gm,dgdx,x,iwsg,iwse);


  fprintf(stdout,"System: C-CR-FE\n");
  fprintf(stdout,"Phase: %s\n",phas);
  fprintf(stdout,"Constitution: (CR,FE)1(C,VA)1\n");
  fprintf(stdout,"Temperature: %f\n",tp[0]);
  fprintf(stdout,"Pressure: %f\n",tp[1]);
  fprintf(stdout,"X(C)=%f,  X(CR)=%f,  X(FE)=%f\n",x[0],x[1],x[2]);
  fprintf(stdout,"\n");
  fprintf(stdout,
	  "Gm=%f\nGmX(C)=%f  GmX(CR)=%f  GmX(FE)=%f\n",
	  gm,dgdx[0],dgdx[1],dgdx[2]);
  fprintf(stdout,"\n");

  /*   calculate chemical potentials using a standard formula */
  for (i=0; i<3; i++ ){
    amu[i]=gm;
    for (j=0; j<3; j++) {
      if (i==j) {
	amu[i]=amu[i]+(1.0-x[j])*dgdx[j];
      }
      else {
	amu[i]=amu[i]-x[j]*dgdx[j];
      }
    }
  }
  fprintf(stdout,"MU(C)=%f, MU(CR)=%f, MU(FE)=%f\n",amu[0],amu[1],amu[2]);
  fprintf(stdout,"\n");

  /*   get system species index */
  for (i=0; i<3; i++) {
    tq_gsspi(spname[i].component,&isp[i],iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error %d in tqgsspi \n",ierr);
      return;
    }
  }

  /*   get mobility data */
  for (i=0; i<3; i++) {
    tq_gmob(iph,isp[i],&x[i],iwsg,iwse);
  }

  fprintf(stdout,"M(C)=%g, M(CR)=%g, M(FE)=%g\n",x[0],x[1],x[2]);
  fprintf(stdout,"\n");


  free(work);
  free(iwork);
  free(dgdy);
  free(amu);
  free(extra);
  free(yf);
  free(as);
  free(nscon);
  free(x);
  free(spname);
  free(tp);
  free(phas);
  free(str);
  free(gfile);
  free(iwsg);
  free(iwse);
}
