/************************************************************************/
/*                                                                      */
/*    This simple sample program display the diffusion matrix in a      */
/*    multicomponent system                                             */
/*                                                                      */
/************************************************************************/

#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
main(int argc, char *argv)
{

  TC_INT *iwsg,*iwse;
  TC_STRING gfile;
  TC_STRING str;
  TC_STRING phas1;
  TC_FLOAT t,p,n,xfcr,xfc,dc1,dc2,dc3,dc4;
  TC_INT ierr,numcon,iph1,icmp1,icmp2;
  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];

#ifdef WIN32
  _set_output_format(_TWO_DIGIT_EXPONENT);
#endif

  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  gfile=malloc(TC_STRLEN_MAX);
  str=malloc(TC_STRLEN_MAX);
  phas1=malloc(TC_STRLEN_PHASES);

  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));

  /* init */
  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);

  strcpy(gfile,"TQEX08.GES5");
  tq_rfil(gfile,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"Failed to open the data file! %d\n",ierr);
    return;
  }
  
  strcpy(phas1,"FCC_A1");

  tq_gsci(&icmp1,"C",iwsg,iwse);
  tq_gsci(&icmp2,"CR",iwsg,iwse);
  tq_gpi(&iph1,phas1,iwsg,iwse);


  p=101325.0;
  n=1.0;
  t=1000.0;

  xfc=0.01;
  xfcr=0.1;

  tq_csp(iph1,"ENTERED",1.0,iwsg,iwse);

  tq_setc("P",-1,-1  ,p ,&numcon,iwsg,iwse);
  tq_setc("T",-1,-1  ,t ,&numcon,iwsg,iwse);
  tq_setc("N",0,0  ,n ,&numcon,iwsg,iwse);
  tq_setc("X",-1,icmp1,xfc,&numcon,iwsg,iwse);
  tq_setc("X",-1,icmp2,xfcr,&numcon,iwsg,iwse);

  tq_ce(" ",0,0,0.0,iwsg,iwse);
  tq_get1("DC(FCC,C,C,FE)",-1,-1,&dc1,iwsg,iwse);
  tq_get1("DC(FCC,C,CR,FE)",-1,-1,&dc2,iwsg,iwse);
  tq_get1("DC(FCC,CR,C,FE)",-1,-1,&dc3,iwsg,iwse);
  tq_get1("DC(FCC,CR,CR,FE)",-1,-1,&dc4,iwsg,iwse);
	
  fprintf(stdout,"%s\n   %16s  %16s\n%s %16g  %16g\n%s %16g  %16g\n",
	  "Diffusion matrix in FCC Fe-Cr-C",
	  "C","CR",
	  "C  ",dc1,dc2,
	  "CR ",dc3,dc4);

  free(phas1);
  free(str);
  free(gfile);
  free(iwsg);
  free(iwse);
}
