/************************************************************************/
/*                                                                      */
/*    This sample program also simulate the non-equilibrium             */
/*    solidification under the Scheil-Guilliver condition.              */
/*                                                                      */
/************************************************************************/
#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
main(int argc, char *argv)
{

  TC_INT *iwsg,*iwse;

  TC_INT
    numcon,
    i, nkomp, ikomp, nphase,
    liquid, solid, ii, jj, numt, indexc;

  TC_INT ierr,ibreak;

  TC_FLOAT
    c0[10], cliq[10],
    cliqalt,
    t, tliq, tsol, dt, fsneu, dfl, tstart,
    fracsol, hliq, hsol, dgm,
    itt, fl,dgmax;

  TC_STRING
    datei,namep;
  
  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];


  FILE *out;

  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  datei=malloc(TC_STRLEN_MAX);
  namep=malloc(TC_STRLEN_PHASES);

  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));

  /* Initialize and read datafile */
  strcpy(datei,"TQEX04");
  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);
  if (tq_sg2err(&ierr)){fprintf(stdout,"%d\n",ierr); }
  tq_rfil(datei,iwsg,iwse);
  if (tq_sg2err(&ierr)){fprintf(stdout,"%d\n",ierr); }

  out=fopen("scheil.out","w");

  /* Get number of components  */
  tq_gnc(&nkomp,iwsg,iwse);
  if (tq_sg2err(&ierr)){fprintf(stdout,"%d\n",ierr); }

  /* Get number of phases  */
  tq_gnp(&nphase,iwsg,iwse);
  if (tq_sg2err(&ierr)){fprintf(stdout,"%d\n",ierr); }
  
  /* Get the index of the liquid  */
  tq_gpi(&liquid,"LIQ",iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"No liquid %d\n",ierr);
    return;
  }

  /* Set units */
  tq_ssu("T","C",iwsg,iwse);
  tq_ssu("MASS","gram",iwsg,iwse);

  /* Set alloy composition  1=Al, 2=Mg, 3=Si  */
  c0[2]=0.06;
  c0[1]=0.06;
  ikomp=1;
  c0[0]=1. - c0[2] - c0[1];

  /* Set equilibrium conditions  */
  /* Compute the liquidus temperature */
  for (i=2; i < nkomp+1; i++) {
    tq_setc("X",0,i,c0[i-1],&numcon,iwsg,iwse);
  }
      
  tq_setc("N",0,0,1.0,&numcon,iwsg,iwse);
  tq_setc("P",0,0,1.0e5,&numcon,iwsg,iwse);


  /* first a calculation at fixed T at low T with little or no liquid */
  tq_setc("T",0,0,3000.0,&numt,iwsg,iwse);
  tq_ce(" ", 0, 0, 0.0, iwsg,iwse);

  /* calculate when amount liquid is 1 mole, i.e. liquidus */
  tq_remc(numt,iwsg,iwse);
  tq_csp(liquid,"FIXED",1.0,iwsg,iwse);
  tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
  tq_get1("T",0,0,&tliq,iwsg,iwse);

  /* calculate when amount liquid is 0 mole but stable, i.e. Solidus */
  tq_csp(liquid,"FIXED",0.0,iwsg,iwse);
  tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
  if (tq_sg2err(&ierr)){fprintf(stdout,"%d\n",ierr); }
  tq_get1("T",0,0,&tsol,iwsg,iwse);
  tq_csp(liquid,"ENTERED",1.0,iwsg,iwse);
  itt=tliq+0.5;
  tstart=itt;
  tq_setc("T",0,0,tstart,&numt,iwsg,iwse);
  tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
  if (tq_sg2err(&ierr)){fprintf(stdout,"%d\n",ierr); }
  tq_reserr();
  fprintf(stdout,"Tliq = %f\n",tliq);
  fprintf(stdout,"Tsol = %f\n",tsol);
  fprintf(out,"#Tliq = %f\n",tliq);
  fprintf(out,"#Tliq = %f\n",tsol);
  
  t = tliq;
  fracsol = 0.0;
  dt = 1.0;
  fsneu = 0.0;

  /* Determine what solid phase will form by extracting the */
  /* driving forces */
  dgmax=-1.0e2;
  ii=0;
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"%d\n",ierr);
    tq_reserr();
  }

  while(ii < nphase ) {
	ii++;
    if ( ii != liquid ) {
      jj=ii;
      indexc=0;
      tq_get1("dg", jj, indexc, &dgm, iwsg,iwse);
      if (tq_sg1err(&ierr)){
	fprintf(stdout,"%d\n",ierr);
	tq_reserr();
      }
      if ( dgm > dgmax ) {
	dgmax=dgm;
	solid=ii;
      }
    }
  }

  if (tq_sg2err(&ierr)){fprintf(stdout,"%d\n",ierr); }

  tq_gpn(solid,namep, TC_STRLEN_PHASES,iwsg,iwse);
  fprintf(stdout,"%s is the first solid phase\n",namep);

  /* cliq should be set to the alloy composition  */
  for (i=2; i < nkomp; i++) {
    cliq[i-1]=c0[i-1];
  }
  cliqalt=cliq[ikomp-1];

  /* The enthalpy of the system at the liquidus temperature  */
  if (tq_sg2err(&ierr)){fprintf(stdout,"%d\n",ierr); } 

  tq_get1("HM", 0, 0, &hliq, iwsg,iwse);
  
  fprintf(stdout,"H(liq) %f\n",hliq);
  fprintf(out,"%f %f %f %f %f\n",t,fracsol,0.0,cliqalt,cliqalt);

  /* loop over the temperature  */
  fl=1.0;
  while (true) {
    fprintf(stdout,"%f %f %f %f\n",t,fl,c0[1],c0[2]);
    /* Exit the loop when two solid phases are stable  */
    i=0;
    while (i < nphase ) {
      ibreak=0;
      i++;
      jj=i;
      if ( jj != liquid && jj != solid ) {
	tq_get1("dg",jj,0,&dgm,iwsg,iwse);
	if (dgm == 0.0) {
	  tq_gpn(i,namep,TC_STRLEN_PHASES,iwsg,iwse);
	  fprintf(stdout,"A third phase is stable %s\n",namep);
	  ibreak=1;
	  break;
	}
      }
    }
    if (ibreak == 1) {break; }
    t=t-dt;
    /* Compute equilibrium at T with cliq as new alloy composition  */
    tq_setc("T",0,0,t,&numt,iwsg,iwse);
    tq_setc("X",0,2,c0[1],&numcon,iwsg,iwse);
    tq_setc("X",0,3,c0[2],&numcon,iwsg,iwse);
    tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
    if (tq_sg1err(&ierr)){
      fprintf(stdout,"%d\n",ierr);
      tq_reserr();
    }

    tq_get1("X",liquid,2,&c0[1],iwsg,iwse);
    tq_get1("X",liquid,3,&c0[2],iwsg,iwse);
    tq_get1("NP",liquid,0,&dfl,iwsg,iwse);
    fl=fl*dfl;
    fracsol=1.0-fl;
    /* Results: fs as function of T  */
    fprintf(out,"%f %f %f %f\n",t,fracsol,c0[1],c0[2]);
  }
  fprintf(stdout,"Amount of primary phase %f\n",fracsol);

  /* The enthalpy of the system at the solidus temperature  */
  tq_get1("HM",0,0,&hsol,iwsg,iwse);
  fprintf(stdout,"delta Hmelt %f\n",hliq-hsol);

  fclose(out);


  free(namep);
  free(datei);
  free(iwsg);
  free(iwse);
}
