/************************************************************************/
/*                                                                      */
/*    This sample program simulate the non-equilibrium solidification   */
/*    under the Scheil-Guilliver condition.                             */
/*                                                                      */
/************************************************************************/
#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
main(int argc, char *argv)
{

  TC_INT *iwsg,*iwse;
  TC_STRING file;
  tc_components_strings *ncom;
  TC_FLOAT tp[5],wp[TC_MAX_NR_OF_ELEMENTS],sum,val,valt,valp;
  TC_FLOAT dh,tstep,dval,valh1,valh2,vallp;
  TC_INT ierr,ne,i,ncont,ncond,idp,ncon;
  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];
  char* str;

  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  file=malloc(TC_STRLEN_MAX);
  ncom=malloc(TC_MAX_NR_OF_ELEMENTS*sizeof(tc_components_strings));
  str=malloc(TC_STRLEN_MAX);

  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));

  /* initializing */
  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);

  /* read thermodynamic data from a GES file */
  fprintf(stdout,"Thermodynamic data file /TQEX03/:");
  fgets(file,TC_STRLEN_MAX,stdin);
  if ( file[0] == 10) { strcpy(file,"TQEX03.GES5"); }
  tq_rfil(file,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"Failed to open the data file! %d\n",ierr);
    return;
  }

  /* input of T and P */
  fprintf(stdout,"Temperature (C) /1800/: ");
  fgets(str,TC_STRLEN_MAX,stdin);
  if (str[0] == 10 ){
    tp[0]=1800; }
  else {
    tp[0]=atof(str); }
  fprintf(stdout,"Pressure (bar) /101325/: ");
  fgets(str,TC_STRLEN_MAX,stdin);
  if (str[0] == 10 ){
    tp[1]=101325; }
  else {
    tp[1]=atof(str); }

  /* input of composition of components, first the number of components */
  tq_gcom(&ne,ncom,iwsg,iwse);
  if (tq_sg1err(&ierr)){ 
    fprintf(stdout,"error %d\n",ierr);
    return;  }

  sum=100.0;
  for (i=0; i < ne-1; i++) {
    fprintf(stdout,"Weight percent of %s:",ncom[i].component);
    str[0]=10;
    while ( str[0] == 10 ) {
      fgets(str,TC_STRLEN_MAX,stdin);
      if (str[0] != 10 ){
	wp[i]=atof(str); }
      if (wp[i] < 0 || wp[i] > 100 ) {
	fprintf(stdout,"Value out of limits\n");
	str[0]=10;
      }
    }
    sum=sum-wp[i];
  }

  /* set equlibrium condition, P */
  val=tp[1];
  tq_setc("P",-1,-1  ,val ,&ncond,iwsg,iwse);
  /* set equlibrium condition, N */
  tq_setc("N",-1,-1  ,1.0 ,&ncond,iwsg,iwse);

  /* set system composition, W */
  for (i=0; i < ne-1; i++) {
    val=wp[i];
    tq_setc("W%",-1, i+1  ,val ,&ncond,iwsg,iwse);
  }

  /* set unit of temperature to Celsius degree */
  tq_ssu("TEMP","C",iwsg,iwse);

  ierr=1;
  while (ierr != 0 ) { 
    /* set equlibrium condition, T */
    valt=tp[0];
    tq_setc("T",-1,-1  ,valt ,&ncont,iwsg,iwse);
    /* calculate equlibrium */
    tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
    /* calculate the liquidus temperature by */
    /* first removing the temperature condition */
    tq_remc(ncont,iwsg,iwse);
    /* then getting the liquid index and setting the amount to 1 */
    tq_gpi(&idp,"LIQUID",iwsg,iwse);
    tq_csp(idp, "FIXED", 1.0, iwsg,iwse);
    /* do a equilibrium calculation and get the liquidus temperature */
    tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
    /* occasionally, it may be difficult get the calculation done. see */
    /* how we are going to handle this situation */
    if (tq_sg2err(&ierr)) {
      tq_reserr();
      tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
      if (tq_sg2err(&ierr)) {
	fprintf(stdout,"Sorry, try a reasonable starting temperature\n");
	tq_reserr();
	return;
      }
    }
  }


  tq_get1("T",0,0,&valt,iwsg,iwse);
  fprintf(stdout,"The liquidus temperature is calculated: %f C\n",valt);
  /* restore the normal condition and perform a calculation */
  tq_csp(idp, "ENTERED", 1.0, iwsg,iwse);
  tq_setc("T",-1,-1  ,valt ,&ncont,iwsg,iwse);
  tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
  if (tq_sg2err(&ierr)) {
    tq_reserr();
    tq_fasv(iwsg,iwse);
    tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
    if (tq_sg2err(&ierr)) {
      fprintf(stdout,"Sorry, try again.\n");
      tq_reserr();
      return;
    }
  }
    
  tq_get1("NP", idp, 0, &valp,iwsg,iwse);
  dh=0.0;
  tstep=1.0;
  fprintf(stdout,"Temperature, C    Liquid Fraction  Latent heat change, J/mol\n");
  fprintf(stdout,"%17.4f %17.4f %17.4f\n",valt,valp,dh);
  valp=1.0;
  /* if remaining liquid fraction less or equal 0.01, end */
  while (valp > 0.01 ) {

    /* now we are going to perform the scheil-gulliver simulation */
    /*  */
    /* displace compositions of liquid phase */
    for (i=0; i < ne-1; i++) {
      tq_get1("W",idp,i+1,&dval,iwsg,iwse);
      tq_setc("W",-1,i+1,dval,&ncon,iwsg,iwse);
    }
    tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
    /* lower the temperature */
    valt=valt-tstep;
    tq_setc("T",-1,-1  ,valt ,&ncont,iwsg,iwse);
    /* get H of liquid phase of the overall composition at this temperature */
    /* before calculation */
    tq_get1("HM",idp,-1,&valh1,iwsg,iwse);
    tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
    /* get H of the system after calculation */
    tq_get1("HM",-1,-1,&valh2,iwsg,iwse);
    /* calculate latent heat evolution */
    dh=dh+valp*(valh2-valh1);
    tq_get1("NP",idp,-1,&vallp,iwsg,iwse);
    valp=valp*vallp;
    fprintf(stdout,"%17.4f %17.4f %17.4f\n",valt,valp,dh);
    
  }

  free(ncom);
  free(file);
  free(iwsg);
  free(iwse);
}
