C/*******************************************************/
C/*                                                     */
C/*    This program show how to retrieve Gibbs energy,  */
C/*    Gibbs energy derivatives and mobilities.         */
C/*                                                     */
C/*******************************************************/

      program tqex09

      implicit double precision (a-h,o-z)
	parameter (maxc=100,maxc1=maxc+1,maxs=10)
	parameter (one=1.d0, zero=0.d0)
      parameter (nwsg=80000,nwsp=500000)
      dimension iwsg(nwsg),iwse(nwsp)
      character*256 tcpath,tmppath
      character*24 gfile,phas,spname(3)
	dimension tp(5),nkl(maxs),knr(maxc),yf(maxc),as(maxs),extra(5)
      dimension x(maxc1)
      integer isp(3)
	logical sg1err,sg2err,tqcmobb
C
      gfile='TQEX08'
      phas='FCC_A1'

      spname(1)='C'
      spname(2)='CR'
      spname(3)='FE'

C..   initialize
      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwsg,nwsp,iwsg,iwse)
C..   read datafile
      call tqrfil(gfile,iwsg,iwse)
C..   get phase index
      call tqgpi(iph,phas,iwsg,iwse)
      if(sg1err(ierr))goto 900
C..   check if mobility data available
      if(.not.tqcmobb(iph,iwsg,iwse)) goto 900
C..   get phase constitution
      call tqgpd(iph,nsg,nkl,as,yf,extra,iwsg,iwse)
C     nsg = number of sublattices
c     nkl(nsg) = number of constituents at each sublattice
c     yf(sigma(nkl(i))) = site fraction in the same order
c     as(nsg) = number of sites in each sublattice.
c     extra(5) = others
C..   input conditions
      tp(1)=1000.d0
      tp(2)=1.d5
      xc=1.d-2
      xcr=5.d-2
      xfe=1.d0-xc-xcr
      yf(1)=xcr/(1.d0-xc)
      yf(2)=xfe/(1.d0-xc)
      yf(3)=as(1)/as(2)*xc/(1.d0-xc)
      yf(4)=1.d0-yf(3)	
C..   input temperature and pressure       
      call tqstp(tp,iwsg,iwse)
C..   input site fractions
      call tqsyf(iph,yf,iwsg,iwse)
C..   get gibbs energy and its first derivatives
	call tqgmdy(iph,x,iwsg,iwse)

	write(6,*)'System: C-CR-FE'
	write(6,*)'Phase: ',phas
	write(6,*)'Constitution: (CR,FE)1(C,VA)1'
	write(6,1010)'Temperature:',tp(1)
	write(6,1011)'Pressure: ',tp(2)
      write(6,20)xc,xcr
20	format(' X(C)=',1P,E12.4,'   X(CR)=',E12.4)
      write(6,30)(x(i)/(as(1)+as(2)*yf(3)),i=1,5)
30	format(' Gm=',1P,E14.7,
     &       /' GmY(CR#1)=',E14.7, '   GmY(FE#1)=',E14.7,
     &       /' GmY(C#2)=',E14.7, '   GmY(VA#2)=',E14.7)
 1010   format(A,G15.5)
 1011   format(A,F15.5)
C..	calculate chemical potentials from partial derivatives
	amuc=(x(4)-x(5))/as(2)
	amucr=(x(1)+(1-yf(4))*(x(5)-x(4))+(1-yf(1))*(x(2)-x(3)))/as(1)
	amufe=(x(1)+(1-yf(4))*(x(5)-x(4))+(1-yf(2))*(x(3)-x(2)))/as(1)
	write(6,40)amuc,amucr,amufe
40	format(' MU(C)=',1P,E14.7,'  MU(CR)=',E14.7,'  MU(FE)=',E14.7)
C..   get system species index
      do i=1,3
         call tqgsspi(spname(i),isp(i),iwsg,iwse)
	   if(sg1err(ierr)) goto 900
      enddo
C..	get mobility data
	do k=1,3
         call tqgmob(iph,isp(k),x(k),iwsg,iwse)
	   if(sg1err(ierr)) goto 900
      enddo
      write(6,50)(x(i),i=1,3) 
50	format(' M(C)=',1P,E14.7,'   M(CR)=',E14.7,'   M(FE)=',E14.7)
900	continue
	end

