C/************************************************************************/
C/*                                                                      */
C/*    This sample program simulate the non-equilibrium solidification   */
C/*    under the Scheil-Guilliver condition.                             */
C/*                                                                      */
C/************************************************************************/

      PROGRAM TQEX03

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NWG=80000,NWP=500000,NC=20,ZERO=0.0D0)
      DIMENSION IWSG(NWG),IWSE(NWP)
      DIMENSION TP(5),WP(NC)
      character*256 tcpath,tmppath
      CHARACTER FILE*60,NCOM(NC)*24,ASK*60
      LOGICAL SG1ERR, SG2ERR

      WRITE(*,1)
 1    FORMAT(
     &' '/
     &'This is a part of the source code samples demonstrating the use'/
     &'of the Thermodynamic calCUlation interface (TQ) for Thermo-Calc'/
     &' '/
     &'This sample program simulate the non-equilibrium solidification'/
     &'under the Scheil-Guilliver condition.'/
     &' '/)

C...initializing
      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwg,nwp,iwsg,iwse)

10    FORMAT(1X,A,$)
20    FORMAT(A)
	
C...read thermodynamic data from a GES file
      WRITE(*,10)'Thermodynamic data file /TQEX03/: '
      READ(*,20)FILE
      IF(LENS(FILE).LE.0) FILE='TQEX03.GES5'
      CALL TQRFIL(FILE,IWSG,IWSE)
      IF(SG2ERR(IERR)) THEN
	  WRITE(*,*)'Failed to open the data file!'
	  GOTO 900
      ENDIF
C...input of T and P
100   WRITE(*,10)'Temperature (C) /1800/: '
      READ(*,*)TP(1)
      WRITE(*,10)'Pressure (bar) /101325/: '
      READ(*,*)TP(2)
C...input of composition of components, first the number of components
      CALL TQGCOM(NE,NCOM,IWSG,IWSE)
      IF(SG1ERR(IERR)) GOTO 900
      SUM=100
      DO 200 I=1,NE-1
          ASK='Weight percent of '//NCOM(I)
 150	  WRITE(*,10)ASK(1:LENS(ASK))//': '
	  READ(*,*)WP(I)
          IF(WP(I).LE.ZERO .OR. WP(I).GE.SUM) THEN
             WRITE(*,*)'Value out of limits'
             GOTO 150
          ENDIF
          SUM=SUM-WP(I)
 200  CONTINUE
C...set equlibrium condition, P
      VAL=TP(2)
      CALL TQSETC('P',-1,-1,VAL,NCOND,IWSG,IWSE)
C...set equlibrium condition, N
      CALL TQSETC('N',-1,-1,1.0D0,NCOND,IWSG,IWSE)
C...set system composition, W
      DO 300 I=1,NE-1
         VAL=WP(I)
         CALL TQSETC('W%',-1,I,VAL,NCOND,IWSG,IWSE)
 300  CONTINUE
C...set unit of temperature to Celsius degree
      CALL TQSSU('TEMP','C',IWSG,IWSE)
C...set equlibrium condition, T
 305  VALT=TP(1)
      CALL TQSETC('T',-1,-1,VALT,NCONT,IWSG,IWSE)
C...calculate equlibrium
      CALL TQCE(' ', 0, 0, 0.0D0, IWSG,IWSE)
C...calculate the liquidus temperature by
C...first removing the temperature condition
      CALL TQREMC(NCONT,IWSG,IWSE)
C...then getting the liquid index and setting the amount to 1
      CALL TQGPI(IDP,'LIQUID',IWSG,IWSE)
      CALL TQCSP(IDP, 'FIXED', 1.0D0, IWSG,IWSE)
C...do a equilibrium calculation and get the liquidus temperature
      CALL TQCE(' ', 0, 0, 0.0D0, IWSG,IWSE)
C...occasionally, it may be difficult get the calculation done. see
C...how we are going to handle this situation
      IF(SG2ERR(IERR)) THEN
          CALL RESERR
          CALL TQCE( ' ', 0, 0, 0.0D0, IWSG,IWSE)
          IF(SG2ERR(IERR)) THEN
              WRITE(*,*)'Sorry, try a reasonable starting temperature'
              CALL RESERR
              GOTO 100
          ENDIF
      ENDIF
      CALL TQGET1( 'T ', 0, 0, VALT, IWSG,IWSE)
      WRITE(*,1010)'The liquidus temperature is calculated: ',VALT,' C'
 1010 format(A,F17.5)
C...restore the normal condition and perform a calculation
      CALL TQCSP(IDP, 'ENTERED', 1.0D0, IWSG,IWSE)
      CALL TQSETC('T',-1,-1,VALT,NCONT,IWSG,IWSE)
      CALL TQCE( ' ', 0, 0, 0.0D0, IWSG,IWSE)
      IF(SG2ERR(IERR)) THEN
         CALL RESERR
         CALL TQFASV(IWSG,IWSE)
         CALL TQCE( ' ', 0, 0, 0.0D0, IWSG,IWSE)
         IF(SG2ERR(IERR)) THEN
            WRITE(*,*)'Sorry, try again.'
            TP(1)=VALT+100.0D0
            CALL RESERR
            GOTO 305
         ENDIF
      ENDIF
C...
      CALL TQGET1('NP', IDP, 0, VALP, IWSG,IWSE)
      DH=0.0D0
      TSTEP=1.0D0
      WRITE(*,399)
     +  'Temperature, C    Liquid fraction  Latent heat change, J/mol'
 399  format(5x,A)
      WRITE(*,800)VALT,VALP,DH
C...
C...now we are going to perform the scheil-gulliver simulation
C...
C...displace compositions of liquid phase
 400  DO 500 I=1,NE-1
      CALL TQGET1('W',IDP,I,DVAL,IWSG,IWSE)
      CALL TQSETC('W',-1,I,DVAL,NCON,IWSG,IWSE)
 500  CONTINUE
      CALL TQCE(' ', 0, 0, 0.0D0, IWSG,IWSE)
C...lower the temperature
      VALT=VALT-TSTEP
      CALL TQSETC('T',-1,-1,VALT,NCONT,IWSG,IWSE)
C...get H of liquid phase of the overall composition at this temperature
C...before calculation
      CALL TQGET1('HM',IDP,-1,VALH1,IWSG,IWSE)
      CALL TQCE(' ', 0, 0, 0.0D0, IWSG,IWSE)
C...get H of the system after calculation
      CALL TQGET1('HM',-1,-1,VALH2,IWSG,IWSE)
C...calculate latent heat evolution
      DH=DH+VALP*(VALH2-VALH1)
      CALL TQGET1('NP',IDP,-1,VALLP,IWSG,IWSE)
C...calculate remaining liquid fraction
      VALP=VALP*VALLP
      WRITE(*,800)VALT,VALP,DH
 800  FORMAT(3(F17.4))
C...if remaining liquid fraction less or equal 0.01, end
      IF(VALP.GT.0.01) GOTO 400
 900  CONTINUE
      END

