/**************************************************************/
/*                                                            */
/*  This program show how to use the functionality for        */
/*  setting how different composition sets should             */
/*  correspond to different compositions. For example, that   */
/*  in the Ni-Al system the composition set fcc_l12#1 should  */
/*  correspond to gamma and fcc_l12#2 to gamma-prime.         */
/*                                                            */
/**************************************************************/


#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
main(int argc, char *argv)
{

  TC_INT *iwsg,*iwse,*iwsr;
  /* for reordering */
  TC_INT TC_NWSR=1000;
  TC_INT ierr;
  TC_INT icont,iconn,iconp,iconw;
  TC_FLOAT* x;
  TC_STRING phase;

  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];
    
  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  iwsr=malloc(sizeof(TC_INT)*TC_NWSR);

  phase=malloc(TC_STRLEN_PHASES);
  x=malloc(sizeof(TC_FLOAT)*2);
  
  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(iwsr,0,sizeof(TC_INT)*TC_NWSR);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));

  /* initiate the workspace */
  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  /* set output unit */
  tq_sio("OUTPUT",6);
  if (tq_sg1err(&ierr)){
    return;
  }
  /* set ERROR unit */
  tq_sio("ERROR",6);
  if (tq_sg1err(&ierr)){
    return;
  }


  /* read the thermodynamic data file which was created by using */
  /* the GES module inside the Thermo-Calc software package */
  tq_rfil("TQEX14",iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  /* set the condition for a sigle equilibrium calculation */
  tq_setc("T",-1,-1,800.0,&icont,iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }
  tq_setc("N",-1,-1,1.0,&iconn,iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }
  tq_setc("P",-1,-1,101325.0,&iconp,iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }
  tq_setc("X",-1,1,0.2,&iconw,iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  tq_lc(iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  tq_ceg(iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  tq_le(iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  tq_ls(iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  /* START of part dealing with reordering of phases */
  /* initialize IWSR workspace */
  tq_roinit(TC_NWSR,iwsr,iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  strcpy(phase,"FCC_L12#1");
  /* component order, X(Al) in this case */
  x[0]=0.25;
  x[1]=0.75;
  tq_setrx(phase,x,iwsr,iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  strcpy(phase,"FCC_L12#2");
  /* request Ni rich CS to be #2 */
  x[0]=0.2;
  x[1]=0.8;
  tq_setrx(phase,x,iwsr,iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }


  strcpy(phase,"FCC_L12#3");
  /* This CS do not exist yet */
  /* need not sum to unity */
  x[0]=0.2;
  x[1]=0.3;
  tq_setrx(phase,x,iwsr,iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  /* List whats set in IWSR */
  tq_lrox(iwsr,iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  tq_order(iwsr,iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }
  /* END of part dealing with reordering of phases */
  /* TQORDER will switch content of FCC_L12#1 and FCC_L12#2 */

  tq_le(iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }

  tq_ls(iwsg,iwse);
  if (tq_sg1err(&ierr)){
    return;
  }



  free(phase);
  free(x);
  free(iwsr);
  free(iwse);
  free(iwsg);
}
