/*******************************************************/
/*                                                     */
/*    This program show how to retrieve Gibbs energy,  */
/*    Gibbs energy derivatives and mobilities.         */
/*                                                     */
/*******************************************************/

#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
main(int argc, char *argv)
{

  TC_INT *iwsg,*iwse;
  TC_STRING gfile;
  TC_STRING str;
  TC_STRING phas;
  TC_FLOAT n,xcr,xc,xfe;
  TC_INT i,ierr,iph,nsub;
  TC_FLOAT *tp,amuc,amucr,amufe;
  TC_FLOAT *as,*yf,*extra,*x;
  TC_INT* nscon;
  tc_components_strings *spname;
  TC_INT isp[3];
  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];

#ifdef WIN32
  _set_output_format(_TWO_DIGIT_EXPONENT);
#endif

  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  gfile=malloc(TC_STRLEN_MAX);
  str=malloc(TC_STRLEN_MAX);
  phas=malloc(TC_STRLEN_PHASES);
  tp=malloc(2*sizeof(TC_FLOAT));
  spname=malloc(sizeof(tc_components_strings)*3);
  nscon=malloc(sizeof(TC_INT)*TC_MAX_NR_OF_SUBLATTICES);
  as=malloc(sizeof(TC_FLOAT)*TC_MAX_NR_OF_SUBLATTICES);
  yf=malloc(sizeof(TC_FLOAT)*TC_MAX_NR_OF_SUBLATTICES*TC_MAX_NR_OF_CONST_PER_SUBLATTICE);
  extra=malloc(sizeof(TC_FLOAT)*5);
  x=malloc(sizeof(TC_FLOAT)*100);
  
  strcpy(phas,"FCC_A1");
  strcpy(spname[0].component,"C");
  strcpy(spname[1].component,"CR");
  strcpy(spname[2].component,"FE");

  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));

  /*   initialize */
  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);

  /*   read datafile */
  strcpy(gfile,"TQEX08.GES5");
  tq_rfil(gfile,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"Failed to open the data file! %d\n",ierr);
    return;
  }

  /*   get phase index */
  tq_gpi(&iph,phas,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"error %d in tqgpi \n",ierr);
    return;
  }

  /*   check if mobility data available */
  if ( !tq_cmobb(iph,iwsg,iwse) ) {
    fprintf(stdout,"No mobility data\n");
    return;
  }
      
  /*   get phase constitution */
  tq_gpd(iph,&nsub,nscon,as,yf,extra,iwsg,iwse);
  /* nsg = number of sublattices */
  /* nkl(nsg) = number of constituents at each sublattice */
  /* yf(sigma(nkl(i))) = site fraction in the same order */
  /* as(nsg) = number of sites in each sublattice. */
  /* extra(5) = others */
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"error %d in tqgpd \n",ierr);
    return;
  }

  /* input conditions */
  tp[0]=1000.0;
  tp[1]=101325.0;
  n=1.0;

  xc=1.e-2;
  xcr=5.e-2;
  xfe=1.0-xc-xcr;
  yf[0]=xcr/(1.0-xc);
  yf[1]=xfe/(1.0-xc);
  yf[2]=as[0]/as[1]*xc/(1.0-xc);
  yf[3]=1.0-yf[2];

  /*   input temperature and pressure        */
  tq_stp(tp,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"error %d in tqstp \n",ierr);
    return;
  }
  /*   input site fractions */
  tq_syf(iph,yf,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"error %d in tqsyf \n",ierr);
    return;
  }

  /*   get gibbs energy and its first derivatives */
  tq_gmdy(iph,x,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"error %d in tqgmdy \n",ierr);
    return;
  }

  fprintf(stdout,"System: C-CR-FE\n");
  fprintf(stdout,"Phase: %s\n",phas);
  fprintf(stdout,"Constitution: (CR,FE)1(C,VA)1\n");
  fprintf(stdout,"Temperature: %f\n",tp[0]);
  fprintf(stdout,"Pressure: %f\n",tp[1]);
  fprintf(stdout,"X(C)=%f,  X(CR)=%f\n",xc,xcr);
  fprintf(stdout,"\n");
  fprintf(stdout,
	  "Gm=%f\nGmY(CR#1)=%f  GmY(CR#1)=%f\nGmY(C#1)=%f  GmY(VA#1)=%f\n",
	  x[0]/(as[0]+as[1]*yf[2]),
	  x[1]/(as[0]+as[1]*yf[2]),
	  x[2]/(as[0]+as[1]*yf[2]),
	  x[3]/(as[0]+as[1]*yf[2]),
	  x[4]/(as[0]+as[1]*yf[2]));
  fprintf(stdout,"\n");

  /* calculate chemical potentials from partial derivatives */
  amuc=(x[3]-x[4])/as[1];
  amucr=(x[0]+(1-yf[3])*(x[4]-x[3])+(1-yf[0])*(x[1]-x[2]))/as[0];
  amufe=(x[0]+(1-yf[3])*(x[4]-x[3])+(1-yf[1])*(x[2]-x[1]))/as[0];
  fprintf(stdout,"MU(C)=%f, MU(CR)=%f, MU(FE)=%f\n",amuc,amucr,amufe);
  fprintf(stdout,"\n");

  /*   get system species index */
  for (i=0; i<3; i++) {
    tq_gsspi(spname[i].component,&isp[i],iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error %d in tqgsspi \n",ierr);
      return;
    }
  }

  /* get mobility data */
  for (i=0; i<3; i++) {
    tq_gmob(iph,isp[i],&x[i],iwsg,iwse);
  }

  fprintf(stdout,"M(C)=%g, M(CR)=%g, M(FE)=%g\n",x[0],x[1],x[2]);
  fprintf(stdout,"\n");

  free(x);
  free(extra);
  free(yf);
  free(as);
  free(nscon);
  free(spname);
  free(tp);
  free(phas);
  free(str);
  free(gfile);
  free(iwsg);
  free(iwse);
}
