/************************************************************************/
/*                                                                      */
/*    This example demonstrates how to use stream calculation to get    */
/*    the enthalpy of a reaction, i.e., the enthalpy difference between */
/*    the reaction products at one temperature and the reactants at     */
/*    another temperature. By setting the enthalpy of reaction to zero, */
/*    the adiabatic temperature can be easily calculated.               */
/*                                                                      */
/************************************************************************/

#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
main(int argc, char *argv)
{

  TC_INT *iwsg,*iwse;
  TC_STRING file;
  TC_INT ip,ic,ierr,inu,numin;
  TC_FLOAT tin,c3h8,o2,val,trea;
  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];
  char* str;

  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  file=malloc(TC_STRLEN_MAX);
  str=malloc(TC_STRLEN_MAX);

  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));

  /* initializing */
  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);

  /* read thermodynamic data from a GES file */
  fprintf(stdout,"Thermodynamic data file /TQEX05/:");
  fgets(file,TC_STRLEN_MAX,stdin);
  if ( file[0] == 10) { strcpy(file,"TQEX05.GES5"); }
  tq_rfil(file,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"Failed to open the data file! %d\n",ierr);
    return;
  }

  /* get the index of the gas phase. */
  tq_gpi(&ip,"GAS",iwsg,iwse);
  if (tq_sg2err(&ierr)) { return; }

  /* create a stream named STREAM1 and input the gas phase at a */
  /* temperature and one atmosphere */
  /* ask for the temperature of the stream */
  while (true) {
    fprintf(stdout,"Stream temperature (K) /298.15/: ");
    fgets(str,TC_STRLEN_MAX,stdin);
    if (str[0] == 10 ){
      tin=298.15; }
    else {
      tin=atof(str); }

    tq_cstm("STREAM1",tin,1.0e5,iwsg,iwse);
    if (tq_sg2err(&ierr)) { return; }
    /* get the index of the consitituent C3H8 in the gas phase */
    tq_gpci(ip,&ic,"C3H8",iwsg,iwse);
    if (tq_sg2err(&ierr)) { return; }
    /* ask and set the amount of C3H8 in the stream */
    fprintf(stdout,"Moles of C3H8 /1/: ");
    fgets(str,TC_STRLEN_MAX,stdin);
    if (str[0] == 10 ){
      c3h8=1.0; }
    else {
      c3h8=atof(str); }
    if (c3h8 <= 0.0 ) {
      fprintf(stdout," *** have a nice day ! *** \n");
      return;
    }
    tq_ssc("STREAM1",ip,ic,c3h8,0,iwsg,iwse);

    /* get the index of the constituent O2 */
    tq_gpci(ip,&ic,"O2",iwsg,iwse);
    if (tq_sg2err(&ierr)) { return; }
    /* ask and set the amount of O2 in the stream */
    fprintf(stdout,"Moles of O2 /5/: ");
    fgets(str,TC_STRLEN_MAX,stdin);
    if (str[0] == 10 ){
      o2=5.0; }
    else {
      o2=atof(str); }
    tq_ssc("STREAM1",ip,ic,o2,0,iwsg,iwse);

    /* ask and set the reaction temperature */
    fprintf(stdout,"Reaction temperature (K) /3000/: ");
    fgets(str,TC_STRLEN_MAX,stdin);
    if (str[0] == 10 ){
      trea=3000; }
    else {
      trea=atof(str); }

    /* set the reaction temperature and pressure */
    tq_setc("T",-1,-1,trea,&inu,iwsg,iwse);
    tq_setc("P",-1,-1,1.0e5,&inu,iwsg,iwse);
    tq_ce(" ",0,0,0.0,iwsg,iwse);
    if (tq_sg2err(&ierr)) { return; }

    /* get the enthalpy of the reaction */
    tq_get1("HX",-1,-1,&val,iwsg,iwse);
    fprintf(stdout,"Initial Enthalpy of reactants = %12.3f J\n",val);
    tq_get1("H",-1,-1,&val,iwsg,iwse);
    fprintf(stdout,"Enthalpy of products at %f K is %12.3fJ\n",trea,val);
    tq_get1("HD",-1,-1,&val,iwsg,iwse);
    fprintf(stdout,"Enthalpy of reaction at %f K is %12.3fJ\n",trea,val);

    /* specify the invariant state variable for the reaction calculation */
    tq_ssic("HD",0.0,iwsg,iwse);
    /* make an estimation of the result temperature, if you can */
    tq_ce("T",0,0,3000.0,iwsg,iwse);
    /* get the temperature */
    tq_get1("T",-1,-1,&val,iwsg,iwse);
    fprintf(stdout,"The adiabatic reaction temperature is %12.3f K\n",val);

    /* delete stream */
    tq_dstm(" ",iwsg,iwse);

  }

  free(str);
  free(file);
  free(iwsg);
  free(iwse);
}
