C/************************************************************************/
C/*                                                                      */
C/*    This sample program shows how to get information about the        */
C/*    paraequilibrium transformation from Fcc to Bcc in a steel         */
C/*                                                                      */
C/************************************************************************/

      program tqex11

      implicit double precision (a-h, o-z)

C...dimension of the workspace should be large enough
      parameter(nwg=80000,nwp=500000)
C
      dimension iwsg(nwg),iwse(nwp),npci(4),ii(5)
	dimension xm(12),xp(12),xim(12),xip(12),amui(12)
      character*256 tcpath,tmppath
      character*24 names(12),name
      character*8 stavar, sname
      logical pstat, tqgsp, tqg1err

      WRITE(*,1)
 1    FORMAT(
     &' '/
     &' This is a part of the source code samples demonstrating '/
     &' the use of the Thermodynamic calCUlation interface (TQ) '/
     &' for Thermo-Calc'/
     &' '/
     &' '/
     &' This sample program shows how to get information about the'/
     &' paraequilibrium tranformation from Fcc to Bcc in a steel '/
     &' '/)

	open(10,file='tqex11_out.dat')

C...initiate the workspace

      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwg,nwp,iwsg,iwse)

C...read the thermodynamic data file which was created by using
C...the GES module inside the Thermo-Calc software package
C...the file tqex10.GES5 contains thermodynamic data of fcc and 
C...bcc in Fe-Mn-C system.

      call tqrfil('TQEX11',iwsg,iwse)

C...get component names in the system

      call tqgcom(icom,names,iwsg,iwse)
      write(6,*) 'This system has the following components:'
      write(10,*) 'This system has the following components:'
      write(6,*) (names(i),i=1,icom)
      write(10,*) (names(i),i=1,icom)
      write(6,*) ' '
      write(6,*) ' '
      write(10,*) ' '
      write(10,*) ' '

C...get the interstitial C and/or N's index

	ni = 0
	do i=1,icom
		if(names(i)(1:lens(names(i))).eq.'C'.or.
     +	   names(i)(1:lens(names(i))).eq.'N') then
			ni = ni + 1
			ii(ni)=i
		endif
		if(names(i)(1:lens(names(i))).eq.'FE') imajor=i
	end do

C...get number of phases in the system

      call tqgnp(iph, iwsg,iwse)
      write(6,1010) 'This system has', iph, ' phases:'
      write(10,1010) 'This system has', iph, ' phases:'
 1010 format(1X,A,I3,A)

C...get names and status of the phases in the system
      do 10 i=1, iph
		call tqgpn(i, name, iwsg,iwse)
		pstat=tqgsp(i, sname, an, iwsg,iwse)
		write(6,1020)  i ,'   ', name, '  ', sname, ' ', an
		write(10,1020)  i ,'   ', name, '  ', sname, ' ', an
 1020           format(I3,A,A,A,A,A,G15.5)
		if(index(name,'FCC').gt.0.and.
     +     (index(name,'#').le.0.or.index(name,'#1').gt.0)) then
			im=i
		elseif(index(name,'BCC').gt.0.and.
     +     (index(name,'#').le.0.or.index(name,'#1').gt.0)) then
		    ip=i
		endif
 10   continue

C.. set mode of calculation
C...mode = 1 or -1 means mole-fraction 
C...mode = 2 or -2 means mass-fraction 
C...mode = 3 or -3 means u-fraction
C...if mode is negative, local equilibrium is not calculated.

	mode=3

C... set matrix composition

	xm(imajor)=1.0d0
	do i=1,icom
		if(i.ne.imajor) then
			xm(i)=1.d-2
			isint=0
			if(abs(mode).eq.3) then
				do j=1,ni
					if(i.eq.ii(j)) isint=1
				end do
			endif
			if(isint.eq.0) xm(imajor)=xm(imajor)-xm(i)
		endif
	enddo
	
	write(6,*)' '
	write(10,*)' '
	write(6,*) 'Matrix composition: '
	write(10,*) 'Matrix composition: '
	write(6,*)' '
	write(10,*)' '

	do i=1,icom
		if(i.ne.imajor) then
			if(abs(mode).eq.1) then
				write(6,40) names(i), xm(i)
				write(10,40) names(i), xm(i)
			elseif(abs(mode).eq.2) then
				write(6,41) names(i), xm(i)
				write(10,41) names(i), xm(i)
			elseif(abs(mode).eq.3) then
				write(6,42) names(i), xm(i)
				write(10,42) names(i), xm(i)
			endif
		endif
	end do

40	format('  X(',A2,')=',1PE12.5)
41	format('  W(',A2,')=',1PE12.5)
42	format('  U(',A2,')=',1PE12.5)

	write(6,45) 'T','DF','XP','XIM','XIP','MU(C)'
	write(10,45) 'T','DF','XP','XIM','XIP','MU(C)'
45	format(' '/6(1x,A12)/' ')
50	format(6(1x,1PE12.5))
	
	do i=0,300,10
		temp=1173.d0-i
          call tqgdf2(mode,im,ip,ni,ii,xm,temp,df,xp,xim,xip,amui,
     +               iwsg,iwse)
		if(.not.tqg1err(ierr)) then
		write(6,50) temp, df, (xp(ii(j)),j=1,ni), (xim(ii(j)),j=1,ni),
     +	            (xip(ii(j)),j=1,ni),(amui(ii(j)),j=1,ni)
		write(10,50) temp, df, (xp(ii(j)),j=1,ni), (xim(ii(j)),j=1,ni),
     +	            (xip(ii(j)),j=1,ni),(amui(ii(j)),j=1,ni)
		else
		write(6,*) temp, 'calculation failed'
		endif
	end do
	close(10)
      end

