C/************************************************************************/
C/*                                                                      */
C/*    This sample program does same thing as Example 9 except that it   */
C/*    demonstrates how to convert mole fractions to                     */
C/*    site fractions and first derivatives of Gm w.r.t. site fractions  */
C/*    to that w.r.t. mole fractions. People feel comfortable            */
C/*    with site fractions and first derivatives w.r.t. them may skip    */
C/*    this example.                                                     */
C/*                                                                      */
C/************************************************************************/

      program tqex10

      implicit double precision (a-h,o-z)
      parameter (maxc=100,maxc1=maxc+1,maxs=10)
      parameter (one=1.d0, zero=0.d0)
      parameter (nwsg=80000,nwsp=500000)
      dimension iwsg(nwsg),iwse(nwsp),iwork(4*maxc)
      character*256 tcpath,tmppath
      character*24 gfile,phas,spname(3)
      dimension tp(5),yf(maxc)
      dimension dgdx(maxc),x(maxc),amu(maxc),dgdy(maxc1)
      dimension work(2000)
      integer isp(3)
      logical tqg2err,tqcmobb

      WRITE(*,1)
 1    FORMAT(
     &' '/
     &' This is a part of the source code samples demonstrating '/
     &' the use of the Thermodynamic calCUlation interface (TQ) '/
     &' for Thermo-Calc'/
     &' '/
     &' This sample program does same thing as Example 9 except '/
     &' that it shows how to convert mole fractions to'/
     &' site fractions and first derivatives of Gm w.r.t. site  '/
     &' fractions to that w.r.t. mole fractions.                '/
     &' '/)

      gfile='TQEX08'
      phas='FCC_A1'

      spname(1)='C'
      spname(2)='CR'
      spname(3)='FE'

C..   initialize
      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwsg,nwsp,iwsg,iwse)

C..   read datafile
      call tqrfil(gfile,iwsg,iwse)

C..   get phase index
      call tqgpi(iph,phas,iwsg,iwse)
      if(tqg2err(ierr)) goto 900

C..   check if mobility data available
      if(.not.tqcmobb(iph,iwsg,iwse)) goto 900

C..   input conditions
      tp(1)=1000.d0
      tp(2)=1.d5
      x(1)=1.d-2
      x(2)=5.d-2
      x(3)=1.d0-x(1)-x(2)

C...  convert mole fractions to y-fractions 
C...  note: only possible if no internal degree of freedom in the phase 

C...  get phase property
      call tqgphp(iph,ne,ncnv,nc,iwork,work,iwsg,iwse)
C...  converting
      call tqx2y(iph,ne,ncnv,nc,iwork,work,x,yf,iwsg,iwse)

C..   input temperature and pressure       
      call tqstp(tp,iwsg,iwse)
C..   input site fractions
      call tqsyf(iph,yf,iwsg,iwse)
C..   get gibbs energy and its first derivatives wrt site fractions
      call tqgmdy(iph,dgdy,iwsg,iwse)
C...  convert to first derivatives wrt mole fractions
      call tqgmdx(iph,ne,ncnv,nc,iwork,work,yf,dgdy,
     &                     gm,dgdx,x,iwsg,iwse)

      write(6,*)'System: C-CR-FE'
      write(6,*)'Phase: ',phas
      write(6,*)'Constitution: (CR,FE)1(C,VA)1'
      write(6,1010)'Temperature:',tp(1)
      write(6,1011)'Pressure: ',tp(2)
      write(6,20)(x(i),i=1,3)
 1010 format(a,G15.5)
 1011 format(a,F15.5)
 20   format(' X(C)=',1P,E12.4,'   X(CR)=',E12.4,'   X(FE)=',E12.4)
      write(6,30)gm,(dgdx(i),i=1,3)
 30   format(' Gm=',1P,E14.7,
     &       /' GmX(C)=',E14.7, '   GmX(CR)=',E14.7,
     &       /' GmX(FE)=',E14.7)

C...  calculate chemical potentials using a standard formula
      do i=1,3
         amu(i)=gm
         do j=1,3
            amu(i)=amu(i)+(delta(i,j)-x(j))*dgdx(j)
         enddo
      enddo
      write(6,40)(amu(i),i=1,3)
 40   format(' MU(C)=',1P,E14.7,'  MU(CR)=',E14.7,'  MU(FE)=',E14.7)
C..   get system species index
      do i=1,3
         call tqgsspi(spname(i),isp(i),iwsg,iwse)
	   if(tqg2err(ierr)) goto 900
      enddo
C..   get mobility data
      do k=1,3
         call tqgmob(iph,isp(k),x(k),iwsg,iwse)
         if(tqg2err(ierr)) goto 900
      enddo
      write(6,50)(x(i),i=1,3) 
 50   format(' M(C)=',1P,E14.7,'   M(CR)=',E14.7,'   M(FE)=',E14.7)
 900  continue
      end
      
      double precision function delta(i,j)
      delta=0.d0
      if(i.eq.j)delta=1.d0
      return
      end

