C/************************************************************************/
C/*                                                                      */
C/*    This simple sample program display the diffusion matrix in a      */
C/*    multicomponent system                                             */
C/*                                                                      */
C/************************************************************************/

      program tqex08

      implicit double precision (a-h,o-z)
      double precision P,N
      parameter (nwsg=80000,nwsp=500000)
      dimension iwsg(nwsg),iwse(nwsp)
      character*256 tcpath,tmppath
      character*32 gfile,phas1,phas2
C
      gfile='TQEX08.GES5'
C
      phas1='FCC_A1'
C
C..   init
      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwsg,nwsp,iwsg,iwse)
      call tqrfil(gfile,iwsg,iwse)
C
      call tqgpi(iph1,phas1,iwsg,iwse)

      call tqgsci(icmp1,'C',iwsg,iwse)
      call tqgsci(icmp2,'CR',iwsg,iwse)

      P=101325.d0
      N=1.0D0
      T=1000.D0

      xFC=0.01
      xFCR=0.1

      call tqcsp(iph1,'ENTERED',1.D0,iwsg,iwse)

      call tqsetc('P',-1,-1  ,P ,numcon,iwsg,iwse)
      call tqsetc('T',-1,-1  ,T ,numcon,iwsg,iwse)
      call tqsetc('N',0,0  ,N ,numcon,iwsg,iwse)
      call tqsetc('X',-1,icmp1,XFC,numcon,iwsg,iwse)
      call tqsetc('X',-1,icmp2,XFCR,numcon,iwsg,iwse)

      call tqce(' ',0,0,0.0D+0,iwsg,iwse)
      call tqget1('DC(FCC,C,C,FE)',-1,-1,dc1,iwsg,iwse)
      call tqget1('DC(FCC,C,CR,FE)',-1,-1,dc2,iwsg,iwse)
      call tqget1('DC(FCC,CR,C,FE)',-1,-1,dc3,iwsg,iwse)
      call tqget1('DC(FCC,CR,CR,FE)',-1,-1,dc4,iwsg,iwse)

 123  format('Diffusion matrix in FCC Fe-Cr-C ',/,
     &        1x,2(12X,A2),/,
     &        2(1X,A3,2(2x,G12.4),/))
      write(*,123)'C','CR','C  ',dc1,dc2,'CR ',dc3,dc4

      end







