C/************************************************************************/
C/*                                                                      */
C/*    This example demonstrates how to use stream calculation to obtain */
C/*    the chill factors in the steelmaking industry.[1]                 */
C/*                                                                      */
C/*    [1] O.Kubaschewski and C.B. Alock, Metellurgical Thermochemistry, */
C/*        1979, Page 211.                                               */
C/*                                                                      */
C/************************************************************************/


      PROGRAM TQEX06

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NWG=80000,NC=20,ZERO=0.0D0)
      PARAMETER (NELSP=10)
      PARAMETER (NWP=500000)
      DIMENSION IWSG(NWG)
      DIMENSION IWSE(NWP)
      character*256 tcpath,tmppath
      CHARACTER FILE*60
      LOGICAL SG2ERR

      WRITE(*,1)
 1    FORMAT(
     &' '/
     &'This is a part of the source code samples demonstrating the use'/1234567
     &'of the Thermodynamic calCUlation interface (TQ) for Thermo-Calc'/
     &' '/
     &'This example demonstrates how to use stream calculation to '/
     &'obtain the chill factors in the steelmaking industry[1].'/
     &' '/
     &'[1] O.Kubaschewski and C.B. Alock, Metellurgical Thermochemistry,
     &'/
     &'    1979, Page 211.'/
     &' '/)

C...initializing
      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwg,nwp,iwsg,iwse)

10    FORMAT(1X,A,$)
20    FORMAT(A)

C...read thermodynamic data from a GES file
      WRITE(6,10)'Thermodynamic data file /TQEX06/: '
      READ(5,20)FILE
      IF(LENS(FILE).LE.0) FILE='TQEX06.GES5'
      CALL TQRFIL(FILE,IWSG,IWSE)
      IF(SG2ERR(IERR)) THEN
	  WRITE(6,*)'Failed to open the data file!'
	  GOTO 900
      ENDIF

C...change temperature unit to C
      CALL tqssu('T','C',iwsg,iwse)


C...create a stream named LIQUID_FE and input Fe liquid at the 1600 C
C...and one atmosphere
      Tliq_fe = 1600.0D0
      CALL TQCSTM('LIQUID_FE',Tliq_fe,1.0D5,IWSG,IWSE)
      IF(SG2ERR(IERR)) GOTO 930

C...get the index of the liquid phase.
      CALL TQGPI(IPL,'LIQUID',IWSG,IWSE)
      IF(SG2ERR(IERR)) GOTO 920

C...get the index of the consitituent Fe in the liquid phase
      CALL TQGPCI(IPL,IC,'FE',IWSG,IWSE)
      IF(SG2ERR(IERR)) GOTO 940

C...set the amount of Fe in the stream to 49 mole
      CALL TQSSC('LIQUID_FE',IPL,IC,49.0D0,0,IWSG,IWSE)

C...create another stream named MASTER_FESI and input Fe1Si1 at the room
C...temperature and one atmosphere

      CALL TQCSTM('MASTER_FESI',25.0D0,1.0D5,IWSG,IWSE)
      IF(SG2ERR(IERR)) GOTO 930

C...get the index of the master alloy FE1SI1_S phase.
      CALL TQGPI(IPS,'FE1SI1_S',IWSG,IWSE)
      IF(SG2ERR(IERR)) GOTO 920

C...set the amount of FE1SI1 in the stream to 1 mole
      CALL TQSSC('MASTER_FESI',IPS,1,1.0D0,0,IWSG,IWSE)

C...set the reaction pressure
      call tqsetc('p',-1,-1,1.0D5,inu,iwsg,iwse)

C...specify the invariant state variable for the reaction calculation
      CALL TQSSIC('HD',0.0D0,IWSG,IWSE)

C...make an estimation of the result temperature, if you can
      CALL TQCE('T',0,0,1500.0D0,IWSG,IWSE)

C...get the temperature
      CALL TQGET1('T',-1,-1,VAL,IWSG,IWSE)
      DT = VAL - Tliq_fe

      WRITE(*,1010)'DT = ', DT
 1010 format(A,G15.5)
      CALL TQGET1('X',-1,2,VAL,IWSG,IWSE)
      write(*,1020)'The comp. of the final solution is ',VAL,' at% Si'
 1020 format(A,G15.5,A)

      CALL TQGET1('DG',IPS,-1,VAL,IWSG,IWSE)
      if(val.lt.0.0D0) then
          WRITE(*,*)'The FE1SI1_S phase should not be stable !'
      else
          Write(*,*)'Strange, FE1SI1_S phase is still stable !'
      endif

C...set the amount of Fe in the stream to 98 mole
      CALL TQSSC('LIQUID_FE',IPL,IC,98.0D0,0,IWSG,IWSE)
C...make a estimation of the result temperature, if you can
      CALL TQCE('T',0,0,1500.0D0,IWSG,IWSE)
C...get the temperature
      CALL TQGET1('T',-1,-1,VAL,IWSG,IWSE)
      DT = VAL - Tliq_fe

      WRITE(*,1010)'DT = ', DT

      CALL TQGET1('X',-1,2,VAL,IWSG,IWSE)
      write(*,1020)'The comp. of the final solution is ',VAL,' at% Si'

      CALL TQGET1('DG',IPS,-1,VAL,IWSG,IWSE)
      if(val.lt.0.0D0) then
          WRITE(*,*)'The FE1SI1_S phase should not be stable !'
      else
          Write(*,*)'Strange, FE1SI1_S phase is still stable !'
      endif

 900  GOTO 990
 910  GOTO 990
 920  GOTO 990
 930  GOTO 990
 940  GOTO 990
 990  CONTINUE
      END


