/************************************************************************/
/*                                                                      */
/*    This sample program demonstrates how to use subroutines getting   */
/*    system data from a database and how to restart new calculation    */
/*    on a different system in the same application program             */
/*                                                                      */
/************************************************************************/

#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
#include "tcutils.h"

main(int argc, char *argv)
{

  TC_INT *iwsg,*iwse;
  TC_INT ierr,calc;
  TC_STRING str,subr,mess;

  tc_databases_strings *dbnames;
  tc_elements_strings *enames;
  tc_phases_strings *phnames;
  TC_INT nd,i,ne,np,ip;
  TC_STRING el1,el2;
  TC_FLOAT t,p,n,x2;
  TC_INT ncp,nct,ncn,iel2,ncx;

  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];

  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  dbnames=malloc(sizeof(tc_databases_strings)*TC_MAX_NR_OF_DATABASES);
  enames=malloc(sizeof(tc_elements_strings)*TC_MAX_NR_OF_ELEMENTS);
  phnames=malloc(sizeof(tc_phases_strings)*TC_MAX_NR_OF_PHASES);
  str=malloc(TC_STRLEN_MAX);
  el1=malloc(TC_STRLEN_ELEMENTS+1);
  el2=malloc(TC_STRLEN_ELEMENTS+1);

  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));


  /* initializing */

  /*Find the necessary path for log file output. (Defaulted to TEMP directory)*/
  getTempEnvironmentPath(log_file_directory);
  /*Find the path to databases. (Defaulted to Thermo-Calc installation directory)*/
  getThermoCalcEnvironmentPath(tc_installation_directory);

  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"error initializing\n");
    return;
  }

  calc=1;
  while (calc==1) {

    tq_rejsy(iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error rejecting system\n");
      return;
    }

    ip=0;
    tq_gdbn(dbnames,&nd,iwsg,iwse);
    for (i=0; i<nd; i++) {
      fprintf(stdout,"%12s",dbnames[i].database);
      ip=ip+12;
      if (ip>60) {
	fprintf(stdout,"\n"); 
	ip=0;
      }
    }
    fprintf(stdout,"\n");
  
    ierr=-1;
    while (ierr != 0) {
      fprintf(stdout,"Select a database from above list:");
      fgets(str,TC_STRLEN_MAX,stdin);
      tq_opdb(str,iwsg,iwse);
      if (tq_sg2err(&ierr)){
	fprintf(stdout,"There is no such database! Try again.\n");
	tq_reserr();
      }
    }
    fprintf(stdout,"\n");
    tq_lide(enames,&ne,iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error listing database elements\n");
      return;
    }
    ip=0;
    for (i=0; i<ne; i++) {
      fprintf(stdout,"%4s",enames[i].element);
      ip=ip+4;
      if (ip>60) {
	fprintf(stdout,"\n");
	ip=0;
      }
    }
    fprintf(stdout,"\n");

    ierr=-1;
    while (ierr != 0) {
      fprintf(stdout,"Select first element from above list:");
      fgets(el1,TC_STRLEN_ELEMENTS+1,stdin);
      tq_defel(el1,iwsg,iwse);
      if (tq_sg2err(&ierr)){
	fprintf(stdout,"There is no such element! Try again.\n");
	tq_reserr();
      }
    }

    ierr=-1;
    while (ierr != 0) {
      fprintf(stdout,"Select second element from above list:");
      fgets(el2,TC_STRLEN_ELEMENTS+1,stdin);
      tq_defel(el2,iwsg,iwse);
      if (tq_sg2err(&ierr)){
	fprintf(stdout,"There is no such element! Try again.\n");
	tq_reserr();
      }
    }
    fprintf(stdout,"\n");

    tq_lisph(phnames,&np,iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error listing all system phases\n");
      return;
    }
    fprintf(stdout,"All Phases for the system in database:\n");
    ip=0;
    for (i=0; i<np; i++) {
      fprintf(stdout,"%12s",phnames[i].phase);
      ip=ip+12;
      if (ip>60) {
	fprintf(stdout,"\n");
	ip=0;
      }
    }
    fprintf(stdout,"\n");

    tq_lissf(phnames,&np,iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error listing selected phases\n");
      return;
    }
    fprintf(stdout,"Selected system phases:\n");
    ip=0;
    for (i=0; i<np; i++) {
      fprintf(stdout,"%12s",phnames[i].phase);
      ip=ip+12;
      if (ip>60) {
	fprintf(stdout,"\n");
	ip=0;
      }
    }
    fprintf(stdout,"\n");

    strcpy(str,"foobar");
    while (strlen(str) > 0) {
      fprintf(stdout,"Reject any phase(s)? /NONE/:");
      fgets(str,TC_STRLEN_MAX,stdin);
      if (str[0] == 10 ){
	strcpy(str,"NONE");
      } 
      if (( strncmp(str,"NONE",4) == 0 ) || (strncmp(str,"none",4) == 0 )) {
	break;
      }
      else {
	tq_rejph(str,iwsg,iwse);
	if (tq_sg2err(&ierr)) {
	  tq_reserr();
	  fprintf(stdout,"Cannot reject phase phase %s\n",str);
	} else {
	  tq_lissf(phnames,&np,iwsg,iwse);
	  fprintf(stdout,"Selected system phases:\n");
	  ip=0;
	  for (i=0; i<np; i++) {
	    fprintf(stdout,"%12s",phnames[i].phase);
	    ip=ip+12;
	    if (ip>60) {
	      fprintf(stdout,"\n");
	      ip=0;
	    }
	  }
	  fprintf(stdout,"\n");
	}
      }
    }

    strcpy(str,"foobar");
    while (strlen(str) > 0 ) {
      fprintf(stdout,"Restore any phase(s)? /NONE/:");
      fgets(str,TC_STRLEN_MAX,stdin);
      if (str[0] == 10 ){
	strcpy(str,"NONE");
      }
      for (ip=0; ip < strlen(str); ip++) {
	if (str[ip]==32) { str[ip]=0; } }
      if (ip > 0 ) { str[ip]=0; }
      if (( strncmp(str,"NONE",4) == 0 ) || (strncmp(str,"none",4) == 0 )) {
	break;
      }
      else {
	tq_resph(str,iwsg,iwse);
	if (tq_sg2err(&ierr)) {
	  tq_reserr();
	  fprintf(stdout,"Cannot restore phase phase %s\n",str);
	} else {
	  tq_lissf(phnames,&np,iwsg,iwse);
	  fprintf(stdout,"Selected system phases:\n");
	  ip=0;
	  for (i=0; i<np; i++) {
	    fprintf(stdout,"%12s",phnames[i].phase);
	    ip=ip+12;
	    if (ip>60) {
	      fprintf(stdout,"\n");
	      ip=0;
	    }
	  }
	  fprintf(stdout,"\n");
	}
      }
    }
    fprintf(stdout,"\n");

    tq_gdat(iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"cannot get data from database\n");
      return;
    }

    p=101325.0;
    t=1000;
    n=1.0;

    x2=-1;
    while ( (x2 < 0.0) || (x2 > 1.0)) {
      fprintf(stdout,"Mole fraction of second element:");
      fgets(str,TC_STRLEN_MAX,stdin);
      if (str[0] == 10 ){
	x2=-1; }
      else
	{ x2=atof(str); }
    }

    tq_setc("P",-1,-1,p,&ncp,iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error setting condition\n");
      return;
    }
    tq_setc("T",-1,-1,t,&nct,iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error setting condition\n");
      return;
    }
    tq_setc("N",-1,-1,n,&ncn,iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error setting condition\n");
      return;
    }
    tq_gsci(&iel2,el2,iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error getting index\n");
      return;
    }
    tq_setc("X",-1,iel2,x2,&ncx,iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error setting condition\n");
      return;
    }

    tq_sp3f("test",iwsg,iwse);


    tq_ceg(iwsg,iwse);
    subr=calloc(1, TC_STRLEN_MAX);
    mess=calloc(1, TC_STRLEN_MAX);
    if (tq_sg3err(&ierr,subr,TC_STRLEN_MAX,mess,TC_STRLEN_MAX)){
      printf("error calculating in routine %s message %s\n", subr, mess);
      return;
    }
    free(subr);
    free(mess);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error calculating\n");
      return;
    }

    tq_sio("OUTPUT",6);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error in sio\n");
      return;
    }
    
    fflush(stdout);
    tq_le(iwsg,iwse);
    if (tq_sg2err(&ierr)){
      fprintf(stdout,"error setting list\n");
      return;
    }

    fprintf(stdout,"Calculation on a new system? /Y/");
    fgets(str,TC_STRLEN_MAX,stdin);
    if (str[0] == 10 ){
      calc=1; }
    else {
      if ( ( strncmp(str,"Y",1) == 0 ) || ( strncmp(str,"y",1) == 0 ) ) {
	calc=1; }
      else {
	calc=0; }
    }
	  
  }	
	
  free(el2);
  free(el1);
  free(str);
  free(phnames);
  free(dbnames);
  free(enames);
  free(iwse);
  free(iwsg);
}
