/************************************************************************/
/*                                                                      */
/*    This sample program calculate the A3 temperature of a steel       */
/*    and determine the influence of each alloying element on this      */
/*    temperature. It demonstrates that some very special quantities,   */
/*    such as the composition derivative of temperature, can be         */
/*    obtained easily via the TQ interface.                             */
/*                                                                      */
/************************************************************************/

#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
main(int argc, char *argv)
{

  TC_INT *iwsg,*iwse;
  TC_STRING file;
  TC_INT i,ierr,ne,nc=6;
  TC_INT ncw[6],ncond,ncont,idp,imn;
  TC_FLOAT tp[5],wp[6],sum,val,valt,vald;
  TC_STRING ask,dtdw;
  tc_components_strings *ncom;
  TC_STRING str;
  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];

  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  file=malloc(TC_STRLEN_MAX);
  str=malloc(TC_STRLEN_MAX);
  ncom=malloc(sizeof(tc_components_strings)*nc);
  ask=malloc(60);
  dtdw=malloc(10);

  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));

  /* initializing */
  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);

  /* read thermodynamic data from a GES file */
  fprintf(stdout,"Thermodynamic data file /TQEX07/:");
  fgets(str,TC_STRLEN_MAX,stdin);
  if ( str[0] == 10) { strcpy(file,"TQEX07.GES5"); }
  else { strcpy(file,str); }
  tq_rfil(file,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"Failed to open the data file! %d\n",ierr);
    return;
  }

  while ( true ) {

    /* input of T and P */
    fprintf(stdout,"Temperature (C) /1000/:");
    fgets(str,TC_STRLEN_MAX,stdin);
    if (str[0] == 10 ){
      tp[0]=1000.0; }
    else {
      tp[0]=atof(str); }

    if (tp[0] < 0.0 ) { break;}

    fprintf(stdout,"Pressure (bar) /100000/:");
    fgets(str,TC_STRLEN_MAX,stdin);
    if (str[0] == 10 ){
      tp[1]=100000.0; }
    else {
      tp[1]=atof(str); }

    /* input of composition of components, first the number of components */
    tq_gcom(&ne,ncom,iwsg,iwse);
    if (tq_sg2err(&ierr)) { return; }

    sum=100.0;
    for (i=0; i<ne; i++ ) {
      if (strcmp(ncom[i].component,"FE") ) {
	strcpy(ask,"Weight percent of ");
	strcat(ask,ncom[i].component);
	wp[i]=-1.0;
	while (wp[i] == 100.0 || wp[i] > 100.0 || wp[i] == 0.0  || wp[i] < 0.0 ) {
	  fprintf(stdout,"%s:",ask);
	  fgets(str,TC_STRLEN_MAX,stdin);
	  wp[i]=atof(str);
	  if (wp[i] < 0.0 ) exit(0);
	}
	sum=sum-wp[i];
      }
    }

    /* set equlibrium condition, P */
    val=tp[1];
    tq_setc("P",-1,-1,val,&ncond,iwsg,iwse);
    /* set equlibrium condition, N */
    tq_setc("N",-1,-1,1.0,&ncond,iwsg,iwse);
  
    /* set system composition, W */
    for (i=0; i<ne; i++ ) {
      if (strcmp(ncom[i].component,"FE")) {
	val=wp[i];
	tq_setc("W%",-1,i+1,val,&ncw[i],iwsg,iwse);
      }
    }
  
    /* set unit of temperature to Celsius degree */
    tq_ssu("TEMP","C",iwsg,iwse);
    
    /* set equlibrium condition, T */
    valt=tp[0]; 
    tq_setc("T",-1,-1,valt,&ncont,iwsg,iwse);
  
    /* calculate equlibrium */
    tq_ce(" ", 0, 0, 0.0,iwsg,iwse);

    /* calculate the A3 temperature by */
    /* first removing the temperature condition */
    tq_remc(ncont,iwsg,iwse);

    /* then getting the bcc index and setting the amount to 0 */
    tq_gpi(&idp,"BCC",iwsg,iwse);
    tq_csp(idp,"FIXED",0.0,iwsg,iwse);
  
    /* do a equilibrium calculation and get the A3 temperature */
    tq_ce(" ", 0, 0, 0.0,iwsg,iwse);

    /* occasionally, it may be difficult get the calculation done. see */
    /* how we are going to handle this situation */
    if (tq_sg2err(&ierr)) { 
      tq_reserr();
      tq_ce(" ", 0, 0, 0.0,iwsg,iwse);
      if (tq_sg2err(&ierr)) { 
	fprintf(stdout,"Sorry, try a reasonable starting temperature or composition.\n");
	return; }
    }

    tq_get1("T",0,0,&valt,iwsg,iwse);
    fprintf(stdout,"The A3 temperature is calculated as %f C\n",valt);

    /* now we shall see how a small change of the alloy composition */
    /* can alter this temperature. This is obtained by getting a very */
    /* special quantity --- the derivative of this temperature with respect */
    /* to the content of an alloying element, i.e. T.W(A). */
    for (i=0; i<ne; i++ ) {
      if (strcmp(ncom[i].component,"FE")) {
	strcpy(dtdw,"T.W(");
	strcat(dtdw,ncom[i].component);
	strcat(dtdw,")");
	tq_get1(dtdw,-1,-1,&vald,iwsg,iwse);
	/* remember what we get is a value with respect to the mass fraction */
	/* in order to have the value refered to the mass percent, we should */
	/* devide the value by 100. */
	vald=vald/100.0;
	if (vald > 0.0) {
	  fprintf(stdout,"The A3 temperature increases %f C with 1 percent increase of %s\n",fabs(vald),ncom[i].component); }
	else {
	  fprintf(stdout,"The A3 temperature decreases %f C with 1 percent increase of %s\n",fabs(vald),ncom[i].component); }
      }
    }

    /* if we want to decrease A3 temperature by 20 C, calculate how much */
    /* Mn we should add to the alloy */
    valt=valt-20.0;
    tq_setc("T",-1,-1,valt,&ncont,iwsg,iwse);
    tq_gsci(&imn,"MN",iwsg,iwse);
    tq_remc(ncw[imn-1],iwsg,iwse);
    tq_ce(" ",0,0,0.0,iwsg,iwse);
    tq_get1("W%",0,imn,&valt,iwsg,iwse);
    fprintf(stdout,"A decrease of the A3 temperature by 20 C needs %f percent more of Mn.\n",valt-wp[imn-1]);
    tq_pini(iwsg,iwse);

    fprintf(stdout,"Let's try another composition. A negative input will terminate the program.\n");
  }
	
  free(dtdw);
  free(ask);
  free(str);
  free(file);
  free(iwsg);
  free(iwse);
}
