/************************************************************************/
/*                                                                      */
/*    This simple sample program calculate the To line for the fcc and  */
/*    bcc phase in the Fe-C system                                      */
/*                                                                      */
/* **********************************************************************/

#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
main(int argc, char *argv)
{
  /* a simple program to get the To line for the fcc and bcc phase */
  /* in the Fe-C system */

  TC_INT *iwsg,*iwse;
  TC_STRING gfile,phas1,phas2;
  TC_FLOAT xmin,xmax,dx,tmin0,tmax0,eps,tmin,tmax,p,n,t,gm1,gm2,gmd,xc;
  TC_INT iph1,iph2,icmp,its,numcon;

  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];


  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  phas1=malloc(TC_STRLEN_PHASES);
  phas2=malloc(TC_STRLEN_PHASES);
  gfile=malloc(TC_STRLEN_MAX);

  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));

  strcpy(gfile,"TQEX02");

  strcpy(phas1,"FCC_A1");
  strcpy(phas2,"BCC_A2");

  xmin=1.0e-3;
  xmax=9.0e-3;
  dx=1.0e-3;
  tmin0=1800.0;
  tmax0=1670.0;

  /* init */
  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);

  tq_rfil(gfile,iwsg,iwse);

  tq_gpi(&iph1,phas1,iwsg,iwse);
  tq_gpi(&iph2,phas2,iwsg,iwse);

  tq_gsci(&icmp,"C",iwsg,iwse);

  eps=1.0e-6;

  for (xc=xmin; xc<=xmax; xc=xc+dx) {

    tmax=tmax0;
    tmin=tmin0;
    t=(tmax0+tmin0)*0.5;
    p=101325.0;
    n=1.0;
    its=0;

    tq_csp(iph1,"SUSPENDED",0.0,iwsg,iwse);
    tq_csp(iph2,"SUSPENDED",0.0,iwsg,iwse);

    tq_setc("P",-1,-1  ,p ,&numcon,iwsg,iwse);
    tq_setc("T",-1,-1  ,t ,&numcon,iwsg,iwse);
    tq_setc("N",-1,-1  ,n ,&numcon,iwsg,iwse);
    tq_setc("X",-1,icmp,xc,&numcon,iwsg,iwse);

    gmd=1/eps;
    while (fabs(gmd) > eps ) {

      ++its;
      tq_setc("T",-1,-1  ,t ,&numcon,iwsg,iwse);

      tq_csp(iph1,"ENTERED",1.0,iwsg,iwse);
      tq_csp(iph2,"SUSPENDED",0.0,iwsg,iwse);
      tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
      gm1=tq_ggm(iph1,iwsg,iwse);

      tq_csp(iph1,"SUSPENDED",0.0,iwsg,iwse);
      tq_csp(iph2,"ENTERED",1.0,iwsg,iwse);
      tq_ce(" ", 0, 0, 0.0, iwsg,iwse);
      gm2=tq_ggm(iph2,iwsg,iwse);

      gmd=(gm1-gm2)/gm1;
      if (gmd < 0.0) {
	tmin=t;
	t=(t+tmax)*0.5;
      }
      if (gmd > 0.0) {
	tmax=t;
	t=(t+tmin)*0.5;
      }
    }
    fprintf(stdout,"X(C),T,its %5g %8.2f %6d\n",xc,t,its);
  }    

  free(phas2);
  free(phas1);
  free(gfile);
  free(iwsg);
  free(iwse);
}
