C/************************************************************************/
C/*                                                                      */
C/*    This example demonstrates how to use stream calculation to get    */
C/*    the enthalpy of a reaction, i.e., the enthalpy difference between */
C/*    the reaction products at one temperature and the reactants at     */
C/*    another temperature. By setting the enthalpy of reaction to zero, */
C/*    the adiabatic temperature can be easily calculated.               */
C/*                                                                      */
C/************************************************************************/


      PROGRAM TQEX05

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (NWG=80000,NC=20,ZERO=0.0D0)
      PARAMETER (NELSP=10)
      PARAMETER (NWP=500000)
      DIMENSION IWSG(NWG),IWSE(NWP)
      character*256 tcpath,tmppath
      CHARACTER FILE*60,SNAME*9,NAME*24
      LOGICAL SG2ERR,SG1ERR,PSTAT,TQGSP

      write(*,1)
 1    format(
     &'This is a part of the source code samples demonstrating the use'/
     &'of the Thermodynamic calCUlation interface (TQ) for Thermo-Calc'/
     &' '/
     &'This example demonstrates how to use stream calculation to get'/
     &'the enthalpy of a reaction, i.e., the enthalpy difference'/
     &'between the reaction products at one temperature and the '/
     &'reactants at another temperature. By setting the enthalpy of '/
     &'reaction to zero, the adiabatic temperature can be easily '/
     &'calculated.'/
     &' '/
     &'In this example, C3H8 is burned in oxygen. The thermodynamic'/
     &'data file used contains data retrieved from the SSUB database.'/
     &'Inputting a negative amount of C3H8 will stop the running of '/
     &'the program.'/
     &' '/)

C...initializing
      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwg,nwp,iwsg,iwse)

10    FORMAT(1X,A,$)
20    FORMAT(A)

C...read thermodynamic data from a GES file
      WRITE(6,10)'Thermodynamic data file /TQEX05/: '
      READ(5,20)FILE
      IF(LENS(FILE).LE.0) FILE='TQEX05.GES5'
      CALL TQRFIL(FILE,IWSG,IWSE)
      IF(SG2ERR(IERR)) THEN
          WRITE(6,*)'Failed to open the data file!'
	  GOTO 900
      ENDIF
C...get the index of the gas phase.
      CALL TQGPI(IP,'GAS',IWSG,IWSE)
      IF(SG2ERR(IERR)) GOTO 920
C...create a stream named STREAM1 and input the gas phase at a
C...temperature and one atmosphere
C...ask for the temperature of the stream
 15   CONTINUE
      WRITE(6,10)'Stream temperature (K) /298.15/: '
      READ(5,*)TIN
      CALL TQCSTM('STREAM1',TIN,1.0D5,IWSG,IWSE)
      IF(SG2ERR(IERR)) GOTO 930
C...get the index of the consitituent C3H8 in the gas phase
      CALL TQGPCI(IP,IC,'C3H8',IWSG,IWSE)
      IF(SG2ERR(IERR)) GOTO 940
C...ask and set the amount of C3H8 in the stream
      WRITE(6,10)'Moles of C3H8 /1/: '
      READ(5,*)C3H8
      IF(C3H8.LT.0.0D0) then
          write(6,*) ' *** have a nice day ! *** '
          GOTO 990
      end if
      CALL TQSSC('STREAM1',IP,IC,C3H8,0,IWSG,IWSE)
C...get the index of the constituent O2
      CALL TQGPCI(IP,IC,'O2',IWSG,IWSE)
C...ask and set the amount of O2 in the stream
      WRITE(6,10)'Moles of O2 /5/: '
      READ(5,*)O2
      CALL TQSSC('STREAM1',IP,IC,O2,0,IWSG,IWSE)
C...ask and set the reaction temperature
      WRITE(6,10)'Reaction temperature (K) /3000/: '
      READ(5,*)TREA
C...set the reaction temperature and pressure
      call tqsetc('t',-1,-1,TREA,inu,iwsg,iwse)
      call tqsetc('p',-1,-1,1.0D5,inu,iwsg,iwse)
      CALL TQCE(' ',0,0,0.0D0,IWSG,IWSE)
      IF(SG2ERR(IERR)) GOTO 900
C...get the enthalpy of the reaction
      CALL TQGET1('HX',-1,-1,VAL,IWSG,IWSE)
      WRITE(*,1010)'Initial Enthalpy of reactants = ', VAL, ' J'
 1010 format(A,F16.5,A)
      CALL TQGET1('H',-1,-1,VAL,IWSG,IWSE)
      WRITE(*,1020)'Enthalpy of products at ',TREA,'K is ', VAL, ' J'
      CALL TQGET1('HD',-1,-1,VAL,IWSG,IWSE)
      WRITE(*,1020)'Enthalpy of reaction at ',TREA,'K is ', VAL,' J'
 1020 format(A,G16.5,A,F16.5,A)
C...specify the invariant state variable for the reaction calculation
      CALL TQSSIC('HD',0.0D0,IWSG,IWSE)
C...make an estimation of the result temperature, if you can
      CALL TQCE('T',0,0,3000.0D0,IWSG,IWSE)
C...get the temperature
      CALL TQGET1('T',-1,-1,VAL,IWSG,IWSE)
      WRITE(*,1010)'The adiabatic reaction temperature is ',VAL,' K'
C...delete stream
      CALL TQDSTM(' ',IWSG,IWSE)
      GOTO 15
 900  GOTO 990
 910  GOTO 990
 920  GOTO 990
 930  GOTO 990
 940  GOTO 990
 950  GOTO 990
 990  CONTINUE
      END






