C/************************************************************************/
C/*                                                                      */
C/*    This simple sample program calculate the To line for the fcc and  */
C/*    bcc phase in the Fe-C system                                      */
C/*                                                                      */
C/************************************************************************/

      program tqex02

C.... a simple program to get the To line for the fcc and bcc phase
C.... in the Fe-C system

      implicit double precision (a-h,o-z)
      double precision P,N
      parameter(nwsg=80000,nwsp=500000)
      dimension iwsg(nwsg),iwse(nwsp)
      character*256 tcpath,tmppath
      character*32 gfile,phas1,phas2
C
      WRITE(*,1)
 1    FORMAT(
     &' '/
     &'This is a part of the source code samples demonstrating the use'/
     &'of the Thermodynamic calCUlation interface (TQ) for Thermo-Calc'/
     &' '/
     &' '/
     &'This simple sample program calculate the To line for the fcc'/
     &'and bcc phase in the Fe-C system.'/
     &' '/)
C
      gfile='TQEX02'
C
      phas1='FCC_A1'
      phas2='BCC_A2'
C
      Xmin=1.D-3
      Xmax=9.D-3
      dX=1.D-3
      Tmin0=1800.D0
      Tmax0=1670.D0
C
C..   init
      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwsg,nwsp,iwsg,iwse)
      call tqrfil(gfile,iwsg,iwse)
C
      call tqgpi(iph1,phas1,iwsg,iwse)
      call tqgpi(iph2,phas2,iwsg,iwse)

      call tqgsci(icmp,'C',iwsg,iwse)

      eps=1.D-6

      do 2000,i=0,int((Xmax-Xmin)/dX)
         XC=Xmin+dX*float(i)

         Tmax=Tmax0
         Tmin=Tmin0
         T=(Tmax0+Tmin0)*0.5D0
         P=101325.d0
         N=1.0D0
         its=0

         call tqcsp(iph1,'SUSPENDED',0.0d0,iwsg,iwse)
         call tqcsp(iph2,'SUSPENDED',0.0d0,iwsg,iwse)

         call tqsetc('P',-1,-1  ,P ,numcon,iwsg,iwse)
         call tqsetc('T',-1,-1  ,T ,numcon,iwsg,iwse)
         call tqsetc('N',-1,-1  ,N ,numcon,iwsg,iwse)
         call tqsetc('X',-1,icmp,XC,numcon,iwsg,iwse)

 100     continue

           its=its+1

           call tqsetc('T',-1,-1  ,T ,numcon,iwsg,iwse)

           call tqcsp(iph1,'ENTERED',1.0d0,iwsg,iwse)
           call tqcsp(iph2,'SUSPENDED',0.0d0,iwsg,iwse)
           call tqce(' ',0,0,0.0D+0,iwsg,iwse)
           gm1 = tqggm(iph1,iwsg,iwse)

           call tqcsp(iph1,'SUSPENDED',0.0d0,iwsg,iwse)
           call tqcsp(iph2,'ENTERED',1.0d0,iwsg,iwse)
           call tqce(' ',0,0,0.0D+0,iwsg,iwse)
           gm2 = tqggm(iph2,iwsg,iwse)

           gmd=(gm1-gm2)/gm1
           if (abs(gmd).le.eps) goto 200
           if (gmd.lt.0.D0) then
              Tmin=T
              T=(T+Tmax)*0.5D0
           endif
           if (gmd.gt.0.D0) then
              Tmax=T
              T=(T+Tmin)*0.5D0
           endif
           goto 100

 200     continue

         write(*,1010)' X(C),T,its ',XC,T,its
 1010    format(A,G14.5,G14.5,I3)
 2000 continue
      end
