C/**************************************************************/
C/*                                                            */
C/*  This program show how to use the functionality for        */
C/*  setting how different composition sets should             */
C/*  correspond to different compositions. For example, that   */
C/*  in the Ni-Al system the composition set fcc_l12#1 should  */
C/*  correspond to gamma and fcc_l12#2 to gamma-prime.         */
C/*                                                            */
C/**************************************************************/

C
C  FUNCTIONS:
C  TQEXreorderCS - Entry point of console application.
C

C****************************************************************************
C
C  PROGRAM: TQEXreorderCS
C
C  PURPOSE:  Entry point for the console application.
C
C****************************************************************************

      program TQEXreorderCS
      implicit none
C...dimension of the workspace should be large enough
      integer nwe,nwg
      parameter (nwe=80000,nwg=80000)
      integer iwsg(nwg),IWSE(nwe),IERR
      integer icont,iconn,iconp,iconw
      logical SG1ERR,sg2err
C for reordering
      integer nwr
      parameter (nwr=102)
      integer IWSR(NWR)
      double precision X(2)
      character*256 tcpath,tmppath
      character*24 phase


C...initiate the workspace
      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwg,nwe,iwsg,iwse)
      if(sg2err(ierr)) goto 900

C set output unit
      call TQSIO('OUTPUT',6)
      if(sg2err(ierr)) goto 900
C set ERROR unit
      call TQSIO('ERROR',6)
      if(sg2err(ierr)) goto 900

C...read the thermodynamic data file which was created by using
C...the GES module inside the Thermo-Calc software package
      call tqrfil('TQEX14',iwsg,iwse)
      if(sg2err(ierr)) goto 900

C...set the condition for a sigle equilibrium calculation
      call tqsetc('T',-1,-1,800.0D0,icont,iwsg,iwse)
      call tqsetc('N', -1, -1, 1.00D0, iconn, iwsg,iwse)
      call tqsetc('P',-1,-1,101325.0D0,iconp,iwsg,iwse)
      call tqsetc('X',-1,1, 0.2D0, iconw, iwsg,iwse)

      CALL TQLC(iwsg,iwse)
      if(sg2err(ierr)) goto 900

      CALL TQCEG(iwsg,iwse)
      if(sg2err(ierr)) goto 900

      CALL TQLE(iwsg,iwse)
      if(sg2err(ierr)) goto 900

      CALL TQLS(iwsg,iwse)
      if(sg2err(ierr)) goto 900

C     START of part dealing with reordering of phases
C     initialize IWSR workspace
      CALL TQROINIT(NWR,IWSR,IWSG,IWSE)
      if(sg2err(ierr)) goto 900

      phase='FCC_L12#1'
C     component order, X(Al) in this case
      X(1)=0.25d0
      X(2)=0.75d0
      CALL TQSETRX(phase,X,IWSR,IWSG,IWSE)
      if(sg2err(ierr)) goto 900

      phase='FCC_L12#2'
C     request Ni rich CS to be #2
      X(1)=0.20d0
      X(2)=0.80d0
      CALL TQSETRX(phase,X,IWSR,IWSG,IWSE)
      if(sg2err(ierr)) goto 900

      phase='FCC_L12#3'
C     This CS do not exist yet
C     need not sum to unity
      X(1)=0.20d0
      X(2)=0.30d0
      CALL TQSETRX(phase,X,IWSR,IWSG,IWSE)
      if(sg2err(ierr)) goto 900

C     List whats set in IWSR
      CALL TQLROX(IWSR,IWSG,IWSE)
      if(sg2err(ierr)) goto 900

      CALL TQORDER(IWSR,IWSG,IWSE)
      if(sg2err(ierr)) goto 900
C     END of part dealing with reordering of phases
C     TQORDER will switch content of FCC_L12#1 and FCC_L12#2

      CALL TQLE(iwsg,iwse)
      if(sg2err(ierr)) goto 900

      CALL TQLS(iwsg,iwse)
      if(sg2err(ierr)) goto 900

900   IF(SG1ERR(IERR))CALL RESERR
      end

