C/************************************************************************/
C/*                                                                      */
C/*    This sample program shows how to retrieve data from a Thermo-     */
C/*    Calc data file, then define a set of conditions for a single      */
C/*    equilibrium calculation, get the equilibrium phases and their     */
C/*    amounts and compositions. The method of calculating the liquidus  */
C/*    and solidus temperature is also demonstrated.                     */
C/*                                                                      */
C/************************************************************************/

      program tqex01

      implicit double precision (a-h, o-z)

C...dimension of the workspace should be large enough
      integer size
      parameter(nwg=80000,nwp=500000,size=2)
C
      dimension iwsg(nwg),iwse(nwp)
      character*256 tcpath,tmppath,SUBR, MESS
      character*24 names(5),name
      character*8 stavar, sname
      logical pstat, tqgsp, sg2err

      double precision surface_energy,tqgse,t,x(2),vm,vp
      double precision XM(size),XP(size)
      integer ipm,ipp,imc,iwsg,iwse
      
      WRITE(*,1)
 1    FORMAT(
     &' '/
     &'This is a part of the source code samples demonstrating the use'/
     &'of the Thermodynamic calCUlation interface (TQ) for Thermo-Calc'/
     &' '/
     &'This sample program shows how to retrieve data from a Thermo-'/
     &'Calc data file, then define a set of conditions for a single'/
     &'equilibrium calculation, get the equilibrium phases and their'/
     &'amounts and compositions. The method of calculating the'/
     &'liquidus and solidus temperature is also demonstrated. '/)

C...initiate the workspace
      tcpath=' '
      tmppath=' '
      call tqini3(tcpath,tmppath,nwg,nwp,iwsg,iwse)

C...read the thermodynamic data file which was created by using
C...the GES module inside the Thermo-Calc software package
      call tqrfil('TQEX01',iwsg,iwse)

C...get component names in the system
      call tqgcom(icom,names,iwsg,iwse)
      print *, 'This system has the following components:'
      print *, (names(i),i=1,icom)
      print *
      print *

C...get number of phases in the system
      call tqsio('output',6)
      call tqgnp(iph, iwsg,iwse)
      print 1010, 'This system has', iph, ' phases:'
 1010 format(A,I3,A)
C...get names and status of the phases in the system
      do 10 i=1, iph
         call tqgpn(i, name, iwsg,iwse)
         pstat=tqgsp(i, sname, an, iwsg,iwse)
         print 1020, i ,'   ', name, '  ', sname, ' ', an
 10   continue
 1020 format(I3,A,A,A,A,A,g12.3)

C...set the units of some properties.
      call tqssu('ENERGY','CAL',iwsg,iwse)
      call tqssu('T','C',iwsg,iwse)

C...set the condition for a sigle equilibrium calculation
      call tqsetc('T',-1,-1,630.0D0,icont,iwsg,iwse)
      call tqsetc('N', -1, -1, 1.00D0, iconn, iwsg,iwse)
      call tqsetc('P',-1,-1,101325.0D0,iconp,iwsg,iwse)
      call tqsetc('W%',-1, 2, 8.0D0, iconw, iwsg,iwse)

C...calculate equilibrium
      call tqce(' ', 0, 0, 0.0D0, iwsg,iwse)
      if(sg2err(ierr)) then
          print *, 'Calculation failed!'
          goto 900
      end if

      call tqget1('GM',-1,-1,val,iwsg,iwse)
      print 1030, 'At T = 630.0 C, Wt%Cu = 8'
      print 1040, 'The Gibbs energy of the system is ', val, ' Cal/mol.'
 1030 format(A)
 1040 format(A,g12.3,A)
c...find the equilibrium phase(s) and their compositions
      call writepx(iph,iwsg,iwse)

c...find the equilibrium liquidus and solidus temperature of this alloy
c...
c...change the status of the liquid phase to FIXED with amount 1
c...and then remove the temperature condition
      call tqgpi(iliq,'liq',iwsg,iwse)
      call tqcsp(iliq, 'FIXED', 1.0D0, iwsg,iwse)
      call tqremc(icont,iwsg,iwse)
      call tqce(' ',0,0,0.0D0,iwsg,iwse)
      if(sg2err(ierr)) then
          print *, 'Calculation failed!'
          goto 900
      end if
      call tqget1('t',-1,-1,valt,iwsg,iwse)
      print *
      print 1050, 'Tliquidus = ', valt, ' C'
 1050 format(A,g12.3,A)
c...find the equilibrium phase(s) and composition(s)
      call writepx(iph,iwsg,iwse)

c...change the status of the liquid phase to FIXED with amount 0
      call tqcsp(iliq, 'FIXED', 0.0D0, iwsg,iwse)
      call tqce(' ',0,0,0.0D0,iwsg,iwse)
      if(sg2err(ierr)) then
          print *, 'Calculation failed!'
          goto 900
      end if
      call tqget1('t',-1,-1,valt,iwsg,iwse)
      print *
      print 1060, 'Tsolidus = ', valt, ' C'
 1060 format(A,g12.3,A)
c...find the equilibrium phase(s) and composition(s)
      call writepx(iph,iwsg,iwse)

c...find the temperature where the equilibrium solidification is half done
      call tqcsp(iliq, 'FIXED', 0.5D0, iwsg,iwse)
      call tqce(' ',0,0,0.0D0,iwsg,iwse)
      if(sg2err(ierr)) then
          print *, 'Calculation failed!'
          goto 900
      end if
      call tqget1('t',-1,-1,valt,iwsg,iwse)
      print *
      print 1070, 'Tmid = ', valt, ' C'
 1070 format(A,g12.3,A)
c...find the equilibrium phase(s) and composition(s)
      call writepx(iph,iwsg,iwse)
      goto 1000


 1000 continue
      
C     Compute surface energy
      IF (SG2ERR(IERR)) THEN
          print *, 'Calculation failed!'
          GOTO 900
      END IF
      NAME='FCC_A1'
      call TQGPI (IPP, NAME, IWSG, IWSE)
      IF (SG2ERR(IERR)) THEN
          print *, 'Calculation failed!'
          GOTO 900
      END IF
      
      NAME='LIQUID'
      call TQGPI (IPM, NAME, IWSG, IWSE)
      IF (SG2ERR(IERR)) THEN
          print *, 'Calculation failed!'
          GOTO 900
      END IF
      
      NAME='AL'
      CALL TQGSCI(IMC, NAME, IWSG, IWSE)
      IF (SG2ERR(IERR)) THEN
          print *, 'Calculation failed!'
          GOTO 900
      END IF
      
      x(1)=0.92d0
      x(2)=0.08d0
      t = 873.d0
      VM=0.9D-5
      VP=0.9D-5
      surface_energy =  tqgse(ipm,ipp,imc,t,x,vm,vp,iwsg,iwse)
      IF (SG2ERR(IERR)) THEN
          print *, 'Calculation failed!'
          GOTO 900
      END IF
 900  continue 
      end

      subroutine writepx(iph,iwsg,iwse)
      implicit double precision (a-h, o-z)
      dimension iwsg(*),iwse(*)
      character*24 name
      print *, 'phase name    composition, Wt%Cu     amount'
 10   format(2x,A,2(10x,g12.3))
      do 100 i = 1, iph
         call tqget1('DG', i, -1, val, iwsg,iwse)
         if(val.eq.0.0D0) then
            call tqgpn(i, name, iwsg,iwse)
            call tqget1('np', i, -1, valnp, iwsg,iwse)
            call tqget1('w%', i, 2, valw, iwsg,iwse)
            if (valnp.lt.1.d-12) valnp=0.d0
            print 10, name(1:lens(name)), valw, valnp
         endif
 100  continue
      return
      end
