C
C TQ example that calculates the Gibbs energy for a composition grid
C with a density of "npoints" at 1273K in the C-Cr-Fe system
C
C The code uses MPI to distribute the calculation over several processors
C
C NOTE: Thermo-Calc Software AB will not assist the user with MPI related 
C questions. This example is only meant to show how TQ can be used in
C applications together with MPI.
C
C The example has been tested on Windows 10 64-bit using the Intel MPI runtime
C environment compliant with the MPI-3.1 standard and on linux (CentOS) 64-bit
C using Open MPI version 1.8.
C
      program mpiex
      implicit none
      include 'mpif.h'
      integer npoints
C      parameter (npoints=401)
C      parameter (npoints=301)
C      parameter (npoints=101)
      parameter (npoints=81)
C      parameter (npoints=21)
      integer nwse,nwsg,iwse,iwsg
      parameter (nwsg=80000,nwse=500000)
      dimension iwse(nwse),iwsg(nwsg)
      character*32 tqfile
      logical sg1err
      integer ierr,numcon
      integer*4 ierror,isize,irank,tag
      integer*4 status(MPI_STATUS_SIZE)
      integer*4 mpi_real_type,mpi_int_type,kp,jp
      integer i,j,np,ix1,ix2
      integer istart,iend
      double precision x1,x2
      double precision v1in(npoints*npoints+2*npoints)
      double precision v2in(npoints*npoints+2*npoints)
      double precision vout(npoints*npoints+2*npoints)
      double precision t,p,n,eps
      parameter (eps=1.d-6)
      character*2 el1,el2
      character*80 line
      character*8 date
      character*10 time
      character*5 zone
      integer values0(8),values1(8)
      integer it0,it1

      data tqfile/'tqfile.GES5'/
      data t/1373.15D0/
      data p/1.0D5/
      data n/1.D0/
      data el1/'C'/
      data el2/'CR'/


C.....init MPI and define MPI data types      
      call MPI_INIT(ierror)
      call MPI_COMM_SIZE(MPI_COMM_WORLD, isize, ierror)
      call MPI_COMM_RANK(MPI_COMM_WORLD, irank, ierror)
      tag=100
      mpi_real_type=MPI_DOUBLE_PRECISION
      mpi_int_type=MPI_INTEGER4


C.....initiliaze TQ node by node
      if (irank.eq.0) then
         write(*,*)' init node',irank,isize
         call tqini(nwsg,nwse,iwsg,iwse)
         do i=2,isize
            kp=1
            call MPI_SEND(kp,1,mpi_int_type,i-1,tag,
     &           MPI_COMM_WORLD,ierror)
            call MPI_RECV(jp,1,mpi_int_type,i-1,tag,
     &           MPI_COMM_WORLD,status,ierror)
         enddo
      else
         call MPI_RECV(jp,1,mpi_int_type,0,tag,
     &        MPI_COMM_WORLD,status,ierror)
         write(*,*)' init node',irank
         call tqini(nwsg,nwse,iwsg,iwse)
         call MPI_SEND(kp,1,mpi_int_type,0,tag,
     &        MPI_COMM_WORLD,ierror)

      endif
      call tqrfil(tqfile,iwsg,iwse)
      if (sg1err(ierr)) goto 900

C.....obtain index of indepdent components
      call tqgsci(ix1,el1,iwsg,iwse)
      call tqgsci(ix2,el2,iwsg,iwse)


C.....determine the number of points and calculate the compositions
      if (irank.eq.0) then
         np=0
         do i=0,npoints-1
            x1=float(i)/float(npoints-1)
            x1=max(eps,min(1.d0-eps,x1))
            do j=0,npoints
               x2=float(j)/float(npoints-1)
               x2=max(eps,min(1.d0-eps,x2))
               if ((x1+x2).le.1.d0) then
                  np=np+1
                  v1in(np)=x1
                  v2in(np)=x2
               endif
            enddo
         enddo


         write(*,'(X,A,I8,X,A,I8)')' number of points: ',np,
     &        'approx nr of points / node: ',np/isize

C........time the calculation 0
         call date_and_time(date,time,zone,values0)
         it0=values0(5)*3600+values0(6)*60+values0(7)

C........distribute the calculation evenly on the nodes
         istart=1
         do i=1,isize
            iend=min(np,int(float(i)*float(np)/float(isize)+0.5)+1)
            if (i.eq.isize) iend=np
            kp=iend-istart+1
            if (i.gt.1) then
               write(*,*)' sending data to node ',i-1
               call MPI_SEND(kp,1,mpi_int_type,i-1,tag,
     &              MPI_COMM_WORLD,ierror)
               call MPI_SEND(v1in(istart),kp,mpi_real_type,i-1,tag,
     &              MPI_COMM_WORLD,ierror)
               call MPI_SEND(v2in(istart),kp,mpi_real_type,i-1,tag,
     &              MPI_COMM_WORLD,ierror)
            endif
            istart=iend+1
         enddo
         istart=1
         iend=min(np,int(float(1)*float(np)/float(isize)+0.5)+1)
         kp=iend-istart+1
      else
         call MPI_RECV(kp,1,mpi_int_type,0,tag,
     &        MPI_COMM_WORLD,status,ierror)
         call MPI_RECV(v1in,kp,mpi_real_type,0,tag,
     &        MPI_COMM_WORLD,status,ierror)
         call MPI_RECV(v2in,kp,mpi_real_type,0,tag,
     &        MPI_COMM_WORLD,status,ierror)
      endif

C.....perform the calculations on the nodes
      p=1.d5
      t=1273.d0
      n=1.d0
      call tqsetc('P',-1,-1  ,P ,numcon,iwsg,iwse)
      call tqsetc('T',-1,-1  ,T ,numcon,iwsg,iwse)
      call tqsetc('N',-1,-1  ,N ,numcon,iwsg,iwse)
      jp=0
      do i=1,kp
         line='X'
         call tqsetc(line,-1,ix1,v1in(i),numcon,iwsg,iwse)
         call tqsetc(line,-1,ix2,v2in(i),numcon,iwsg,iwse)
C         call tqce(' ',0,0,0.d0,iwsg,iwse)
         call tqceg(iwsg,iwse)
         jp=jp+1
         call tqget1('GM',-1,-1,vout(jp),iwsg,iwse)
      enddo
      write(*,*)' node ',irank,' done ',kp
      call MPI_BARRIER(MPI_COMM_WORLD,ierror)

C.....send back the results to node 0
      if (irank.ne.0) then
         call MPI_SEND(jp,1,mpi_int_type,0,tag,
     &        MPI_COMM_WORLD,ierror)
         
         call MPI_SEND(vout,jp,mpi_real_type,0,tag,
     &        MPI_COMM_WORLD,ierror)

      else
         istart=kp+1
         do i=2,isize
            write(*,*)' receiving data from node ',i-1
            call MPI_RECV(jp,1,mpi_int_type,i-1,tag,
     &           MPI_COMM_WORLD,status,ierror)
            call MPI_RECV(vout(istart),kp,mpi_real_type,i-1,tag,
     &           MPI_COMM_WORLD,status,ierror)
            istart=istart+jp
         enddo
      endif

C.....display (some of) the results
      if (irank.eq.0) then
         call date_and_time(date,time,zone,values1)

         write(*,*)'result '
         write(*,*)'point#  X('//el1//')       X('//el2//')       GM'
         do i=1,np,np/10
            write(*,'(I8,4(X,G12.5))')i,v1in(i),v2in(i),vout(i)
         enddo

         it1=values1(5)*3600+values1(6)*60+values1(7)
         write(*,*)'time used [s]',it1-it0

      endif


 900  continue
      call MPI_FINALIZE(ierror)
      end

