/************************************************************************/
/*                                                                      */
/*    This sample program shows how to get information about the        */
/*    paraequilibrium transformation from Fcc to Bcc in a steel         */
/*                                                                      */
/************************************************************************/

#define _CRT_SECURE_NO_WARNINGS

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include "tqroot.h"
main(int argc, char *argv)
{

  TC_INT *iwsg,*iwse;
  TC_STRING file;
  TC_STRING str;
  TC_INT ierr;

  TC_INT icom,i,j,ni,*ii,imajor,iph,im,ip;
  TC_INT mode,isint;
  tc_components_strings *names;
  FILE *fd;
  TC_STRING name,sname;
  TC_BOOL pstat;
  TC_FLOAT an,*xm,temp,df;
  TC_FLOAT *xp,*xim,*xip,*amui;

  char log_file_directory[FILENAME_MAX];
  char tc_installation_directory[FILENAME_MAX];

  iwsg=malloc(sizeof(TC_INT)*TC_NWSG);
  iwse=malloc(sizeof(TC_INT)*TC_NWSE);
  file=malloc(TC_STRLEN_MAX);
  str=malloc(TC_STRLEN_MAX);
  name=malloc(TC_STRLEN_PHASES);
  sname=malloc(TC_STRLEN_MAX);

  memset(iwsg,0,sizeof(TC_INT)*TC_NWSG);
  memset(iwse,0,sizeof(TC_INT)*TC_NWSE);
  memset(log_file_directory,0,sizeof(log_file_directory));
  memset(tc_installation_directory,0,sizeof(tc_installation_directory));

  fd=fopen("tqex11c_out.dat","w");

  /* initiate the workspace */
  tq_ini3(tc_installation_directory,log_file_directory,TC_NWSG,TC_NWSE,iwsg,iwse);

  /* read the thermodynamic data file which was created by using */
  /* the GES module inside the Thermo-Calc software package */
  /* the file tqex10.GES5 contains thermodynamic data of fcc and  */
  /* bcc in Fe-Mn-C system. */

  strcpy(file,"TQEX11.GES5");
  tq_rfil(file,iwsg,iwse);
  if (tq_sg2err(&ierr)){
    fprintf(stdout,"Failed to open the data file! %d\n",ierr);
    return;
  }


  /* get component names in the system */
  tq_gnc(&icom,iwsg,iwse);
  names=malloc(sizeof(tc_components_strings)*icom);
  tq_gcom(&icom,names,iwsg,iwse);

  fprintf(stdout,"This system has the following components:\n");
  fprintf(fd,"This system has the following components:\n");
  for (i=0; i<icom; i++) {
    fprintf(stdout,"%s ",names[i].component);
    fprintf(fd,"%s ",names[i].component);
  }
  fprintf(stdout,"\n\n\n");
  fprintf(fd,"\n\n\n");

  ii=malloc(sizeof(TC_INT)*icom);

  xm=malloc(sizeof(TC_FLOAT)*icom);
  xp=malloc(sizeof(TC_FLOAT)*icom);
  xim=malloc(sizeof(TC_FLOAT)*icom);
  xip=malloc(sizeof(TC_FLOAT)*icom);
  amui=malloc(sizeof(TC_FLOAT)*icom);

  /* get the interstitial C and/or N's index */
  ni=0;
  for (i=0; i<icom; i++) {
    if (strcmp(names[i].component,"C") == 0 ||
	strcmp(names[i].component,"N") == 0 ) {
      ni++;
      ii[ni-1]=i+1;
    }
    if (strcmp(names[i].component,"FE") == 0 ) {
      imajor=i;}
  }

  /* get number of phases in the system */
  tq_gnp(&iph,iwsg,iwse);
  fprintf(stdout,"This system has %d phases:\n",iph);
  fprintf(fd,"This system has %d phases:\n",iph);
  /* get names and status of the phases in the system */
  for (i=0; i<iph; i++) {
    tq_gpn(i+1,name,TC_STRLEN_PHASES,iwsg,iwse);
    pstat=tq_gsp(i+1,sname,TC_STRLEN_MAX,&an,iwsg,iwse);
    fprintf(stdout,"%d  name %s  %s %g\n",i+1,name,sname,an);
    fprintf(fd,"%d  name %s  %s %g\n",i+1,name,sname,an);
    if ( strstr(name,"FCC") != NULL) {
      if (strstr(name,"#1") != NULL || strstr(name,"#") == NULL) {
	im=i;
      }
    }
    if (strstr(name,"BCC") != NULL) {
      ip=i;
    }
  }

  /* set mode of calculation */
  /* mode = 1 or -1 means mole-fraction  */
  /* mode = 2 or -2 means mass-fraction  */
  /* mode = 3 or -3 means u-fraction */
  /* if mode is negative, local equilibrium is not calculated. */
  mode=3;
  
  /*  set matrix composition */
  xm[imajor]=1.0;
  for (i=0; i<icom; i++) {
    if (i != imajor) {
      xm[i]=1.e-2;
      isint=0;
      if ( abs(mode) == 3 ) {
	for (j=0; j<ni; j++) {
	  if (i == ii[j]-1 ) { isint=1; }
	}
	if (isint == 0 ) {
	  xm[imajor]=xm[imajor]-xm[i];
	}
      }
    }
  }

  fprintf(stdout,"Matrix composition\n");
  fprintf(fd,"Matrix composition\n");
  for (i=0; i<icom; i++) {
    if (i != imajor) {
      if(abs(mode) == 1) {
	fprintf(stdout,"X(%s)=%f\n",names[i].component,xm[i]);
	fprintf(fd,"X(%s)=%f\n",names[i].component,xm[i]);
      }
      if(abs(mode) == 2) {
	fprintf(stdout,"W(%s)=%f\n",names[i].component,xm[i]);
	fprintf(fd,"W(%s)=%f\n",names[i].component,xm[i]);
      }
      if(abs(mode) == 3) {
	fprintf(stdout,"U(%s)=%f\n",names[i].component,xm[i]);
	fprintf(fd,"U(%s)=%f\n",names[i].component,xm[i]);
      }
    }
  }

  fprintf(stdout,"%12s %12s %12s %12s %12s %12s\n",
	  "T","DF","XP","XIM","XIP","MU(C)");
  for (j=0; j<310; j=j+10) {
    temp=1173.0-j;
    tq_gdf2(mode,im+1,ip+1,ni,ii,xm,temp,&df,xp,xim,xip,amui,iwsg,iwse);
    if (!tq_sg2err(&ierr)) {
      fprintf(stdout,"%12.5g %12.5g ",temp,df);
      fprintf(fd,"%12.5g %12.5g ",temp,df);
      for (i=0; i<ni; i++) {
	fprintf(stdout,"%12.5g ",xp[ii[i]-1]);
	fprintf(fd,"%12.5g ",xp[ii[i]-1]);
      }
      for (i=0; i<ni; i++) {
	fprintf(stdout,"%12.5g ",xim[ii[i]-1]);
	fprintf(fd,"%12.5g ",xim[ii[i]-1]);
      }
      for (i=0; i<ni; i++) {
	fprintf(stdout,"%12.5g ",xip[ii[i]-1]);
	fprintf(fd,"%12.5g ",xip[ii[i]-1]);
      }
      for (i=0; i<ni; i++) {
	fprintf(stdout,"%12.5g ",amui[ii[i]-1]);







	fprintf(fd,"%12.5g ",amui[ii[i]-1]);
      }
      fprintf(stdout,"\n");
      fprintf(fd,"\n");
    } else {
      fprintf(stdout,"%f calculation failed\n",temp);
    }
  }
  
  free(name);
  free(sname);
  free(str);
  free(file);
  free(iwsg);
  free(iwse);
}
