%{
This example shows how to create a property (step) diagram using TC-Python.
The alloy system Fe-Ni is used as an example. 
%}
session = tc_toolbox.TCToolbox();

[filepath,name,ext] = fileparts(mfilename("fullpath"));
session.set_cache_folder( name + "_cache");

tc_system = session.select_database_and_elements("FEDEMO", ["Fe", "Ni"])...
    .get_system();

calculation = tc_system...
        .with_property_diagram_calculation()...
            .with_axis(tc_toolbox.step_or_map_diagrams.CalculationAxis(...
                tc_toolbox.ThermodynamicQuantity.temperature())...
                    .set_min(500)...
                    .set_max(3000)...
                    .with_axis_type(tc_toolbox.step_or_map_diagrams...
                        .Linear().set_min_nr_of_steps(50)))...
        .set_condition(tc_toolbox.ThermodynamicQuantity.temperature(), 1000)...
        .set_condition("W(Ni)", 0.1);

property_diagram = calculation.calculate();

property_diagram.set_phase_name_style(...
    tc_toolbox.step_or_map_diagrams.PhaseNameStyle.ALL);
groups = property_diagram.get_values_grouped_by_quantity_of(...
    tc_toolbox.ThermodynamicQuantity.temperature(),...
    tc_toolbox.ThermodynamicQuantity.volume_fraction_of_a_phase(...
        tc_toolbox.Constants.ALL_PHASES));
      
title("Fe-10Ni");
xlabel("Temperature [K]");
ylabel("Volume fraction of phases [-]");
ylim([0 1]);

hold on                                          
for k = groups.keys()
    label = k{1};  
    group = groups(k{1});
    plot(group.get_x(), group.get_y(), "DisplayName", group.get_label(), ...
        "LineWidth", 2);
end
hold off
legend;
leg = findobj(gcf, "Type", "Legend");
set(leg, "Interpreter", "none");

