%{
Diffusion within a Single Phase Austenitic Region of an Fe-Ni Alloy

This example simulates diffusion within a single phase austenitic region of an Fe-Ni alloy. The  
initial condition is a linear gradient from 10 wt-% - 50 wt-% Ni at 1400 K. 

The example uses a minimum number of required settings. Default values are used for any unspecified settings.
%}

session = tc_toolbox.TCToolbox();

[filepath, name, ext] = fileparts(mfilename("fullpath"));
session.set_cache_folder(name + "_cache");

tc_system = session...
    .select_thermodynamic_and_kinetic_databases_with_elements("FEDEMO", "MFEDEMO", ["Fe", "Ni"])...
    .get_system();

calculator = tc_system...
                .with_isothermal_diffusion_calculation()...
                .set_temperature(1400.0)...
                .set_simulation_time(108000.0)...
                .add_region(tc_toolbox.diffusion.Region("Austenite")...
                    .set_width(100E-6)...
                    .with_grid(tc_toolbox.diffusion.CalculatedGrid.linear()...
                        .set_no_of_points(50))...
                        .with_composition_profile(tc_toolbox.diffusion.CompositionProfile()...
                            .add("Ni", tc_toolbox.diffusion.ElementProfile.linear(10.0, 50.0)))...
                    .add_phase("FCC_A1"));

results = calculator.calculate();

[distance, mass_frac_ni] = results.get_mass_fraction_of_component_at_time("Ni", tc_toolbox.diffusion.SimulationTime.LAST);

plot(distance * 1e6, mass_frac_ni);
title("Single region Fe-Ni");
xlabel("Distance [\mum]");
ylabel("Mass fraction of Ni");
xlim([0 100]);
