%{
Calculates the solidification with and without Solute Trapping.
Then compare the solidification in the two cases by plotting temperature vs. mole fraction of solid phase.
The alloy system Al-Si-Cu is used as an example.
%}


database = "ALDEMO";
dependent_element = "Al";
composition = containers.Map({'Si', 'Cu'}, {7.5, 0.2});  % in wt-%
step = 0.5;
elements = string(composition.keys());

session = tc_toolbox.TCToolbox();

[filepath,name,ext] = fileparts(mfilename("fullpath"));
session.set_cache_folder( name + "_cache");

system = (session...
    .select_database_and_elements(database, [dependent_element elements])...
    .get_system());

scheilCalculator = (system...
    .with_scheil_calculation()...
    .set_composition_unit(tc_toolbox.CompositionUnit.MASS_PERCENT)...
    .with_options(tc_toolbox.scheil.ScheilOptions().set_temperature_step(0.5)));

for element = elements
    scheilCalculator.set_composition(element, composition(element));
end


scheilCalculator.with_calculation_type(tc_toolbox.scheil.ScheilCalculationType.scheil_classic());
scheilResult = scheilCalculator.calculate();

[solid_frac1, temp1] = scheilResult.get_values_of(tc_toolbox.ScheilQuantity.mole_fraction_of_all_solid_phases(),...
    tc_toolbox.ScheilQuantity.temperature());



soluteTrappingCalculator = (system...
    .with_scheil_calculation()...
    .set_composition_unit(tc_toolbox.CompositionUnit.MASS_PERCENT)...
    .with_options(tc_toolbox.scheil.ScheilOptions().set_temperature_step(0.5)));

for element = elements
    soluteTrappingCalculator.set_composition(element, composition(element));
end

soluteTrappingCalculator.with_calculation_type(tc_toolbox.scheil.ScheilCalculationType.scheil_solute_trapping()...
    .set_primary_phasename("AUTOMATIC")...
    .set_angle(45).set_scanning_speed(1));

soluteTrappingresult = soluteTrappingCalculator.calculate();

[solid_frac2, temp2] = soluteTrappingresult.get_values_of(tc_toolbox.ScheilQuantity.mole_fraction_of_all_solid_phases(),...
    tc_toolbox.ScheilQuantity.temperature());





% plot the results
    plot(solid_frac1,temp1,solid_frac2,temp2, "LineWidth", 2);
    legend(["Classic Scheil", "Scheil with Solute Trapping"]);
    title("Solidification in Al- 7.5w% Si- 0.2w% Cu");
    xlabel("Percentage of solidified material [%]");
    ylabel("Temperature [K]");
    