%{
This example shows how to calculate and plot a phase diagram.
The system Fe-Cr is used as an example.
%}
session = tc_toolbox.TCToolbox();

[filepath,name,ext] = fileparts(mfilename("fullpath"));
session.set_cache_folder( name + "_cache");

sb = session.select_database_and_elements("FEDEMO", ["Fe", "Cr"]);
tc_system = sb.get_system();

calculation_setup = ...
    tc_system.with_phase_diagram_calculation()...
        .with_first_axis(tc_toolbox.step_or_map_diagrams.CalculationAxis(...
            tc_toolbox.ThermodynamicQuantity.mole_fraction_of_a_component("Cr"))...
                .set_min(0)...
                .set_max(1.0)...
                .with_axis_type(tc_toolbox.step_or_map_diagrams.Linear()...
                    .set_max_step_size(.025))...
        ).with_second_axis(tc_toolbox.step_or_map_diagrams.CalculationAxis(...
            tc_toolbox.ThermodynamicQuantity.temperature())...
                .set_min(500)...
                .set_max(3000.0)...
                .with_axis_type(...
                    tc_toolbox.step_or_map_diagrams.AxisType.linear()...
                        .set_min_nr_of_steps(60))...
        )...
        .enable_global_minimization()...
        .set_condition(tc_toolbox.ThermodynamicQuantity.temperature(), 1000)...
        .set_condition(...
            tc_toolbox.ThermodynamicQuantity.mole_fraction_of_a_component("Cr"), ...
                10 / 100);

calculation_results = calculation_setup.calculate();
calculation_results.add_coordinate_for_phase_label(0.5, 2000);

phase_diagram = calculation_results.get_values_grouped_by_stable_phases_of(...
    tc_toolbox.ThermodynamicQuantity.mole_fraction_of_a_component("Cr"),...
    tc_toolbox.ThermodynamicQuantity.temperature());

title("Phase diagram Fe-Cr");
xlabel("Mole fraction Cr [-]");
ylabel("Temperature [K]");
xlim([0 1]);
ylim([500 2250]);

hold on

tie_lines = phase_diagram.get_tie_lines();
plot(tie_lines.get_x(), tie_lines.get_y(), "g");

invariant = phase_diagram.get_invariants();
plot(invariant.get_x(), invariant.get_y(), "r");

lines = phase_diagram.get_lines();
plots_in_legend = zeros(length(lines), 1);
index = 1;
for k = lines.keys()
    label = k{1};
    line = lines(k{1});
    plots_in_legend(index) = plot(line.get_x(), line.get_y(), ...
        "DisplayName", line.get_label(), "LineWidth", 2);
    index = index + 1;
end

phase_labels = phase_diagram.get_phase_labels();
for i = 1:length(phase_labels)
    text(phase_labels{i}.get_x(), phase_labels{i}.get_y(), ...
        phase_labels{i}.get_text());
end

legend(plots_in_legend);
leg = findobj(gcf, "Type", "Legend");
set(leg, "Interpreter", "none");
hold off
