%{
This example shows how a very simplified process simulation of a BOF converter
can be set up.
%}

import tc_toolbox.metallurgy_calculation.equilibrium.*;
import tc_toolbox.process_metallurgy.base.*;
import tc_toolbox.process_metallurgy.process.*;
import tc_toolbox.*

session = tc_toolbox.TCToolbox();

[filepath, name, ext] = fileparts(mfilename("fullpath"));
session.set_cache_folder(name + "_cache");

calc = session.with_metallurgy().with_adiabatic_process_calculation(ProcessDatabase.OXDEMO);
calc.set_end_time(15 * 60);

steel_zone = MetalBulkZone(7800);
slag_zone = SlagBulkZone(4500);

steel_zone.add_addition(SingleTimeAddition(containers.Map(["Fe", "C",  "Si"], { NaN, 4.5, 1.0}),...
                                                   120e3, 1600 + 273.15, CompositionUnit.MASS_PERCENT), 0);
slag_zone.add_addition(SingleTimeAddition(containers.Map(["CaO", "SiO2"], { 75, 25}),...
                                                  1.2e3, 1500 + 273.15, CompositionUnit.MOLE_PERCENT), 0);

steel_zone.add_continuous_addition(ContinuousGasAddition(containers.Map({'O2'}, {100}),...
                                                              1, 20 + 273.15));

% the mass transfer coefficient is an empirical parameter that depends on the conditions in the actual converter
calc.with_reaction_zone(ReactionZone(10.0,...
                                     steel_zone, 1.0e-5,...
                                     slag_zone, 1.0e-6));

result = calc.calculate();

disp("Stable phases in the steel melt: " + result.get_stable_phases('metal'))

figure();
plot(result.get_time_points(), result.get_temperature('metal'));
title("Very simple BOF process simulation");
xlabel("Time / s");
ylabel("Temperature of the steel melt / K");


figure();
comp = result.get_composition_of_phase_group('metal', PhaseGroup.ALL_METAL);
hold on
for components = keys(comp)
    component = components{1};
    content = comp(components{1});
    if component ~= "Fe"
        plot(result.get_time_points(), content, 'DisplayName', component)
    end
end
title("Very simple BOF process simulation");
xlabel("Time / s");
ylabel("Steel composition / wt-%");
legend()
hold off







