%{
This example shows how to create a single equilibrium calculation                
from a ternary system and configure it to calculate the solidus 
and liquidus temperature using fixed phase conditions for the 
liquid phase. 
  
There can be multiple solutions to a fixed phase condition and it is 
good practice to perform a regular equilibrium calculation close to 
where the phase transition is. This example starts with an equilibrium 
calculation at 1700 K in order to get good start values.           
%}
session = tc_toolbox.TCToolbox();

sys = session.select_database_and_elements("FEDEMO", ["Fe", "Cr", "C"])...
    .get_system();
calc = sys.with_single_equilibrium_calculation();
calc.set_condition(tc_toolbox.ThermodynamicQuantity.temperature(), 1700);
calc.set_condition(tc_toolbox...
    .ThermodynamicQuantity.mass_fraction_of_a_component("Cr"), 0.1);
calc.set_condition(tc_toolbox.ThermodynamicQuantity...
    .mass_fraction_of_a_component("C"), 0.01);

% calculate equilibrium and list stable phases
result = calc.calculate();
disp("Equilibrium at temperature: " + result.get_value_of(...
    tc_toolbox.ThermodynamicQuantity.temperature()) + " K, stable phases:");
listStablePhases(result);

% calculate liquidus temperature and list stable phases
calc.remove_condition(tc_toolbox.ThermodynamicQuantity.temperature());
calc.set_phase_to_fixed("LIQUID", 1.0);
result = calc.calculate();
disp("Liquidus temperature: " + result.get_value_of(...
    tc_toolbox.ThermodynamicQuantity.temperature()) + " K, stable phases:");
listStablePhases(result);

% calculate solidus temperature and list stable phases
calc.set_phase_to_fixed("LIQUID", 0.0);
result = calc.calculate();
disp("Solidus temperature: " + result.get_value_of(tc_toolbox...
    .ThermodynamicQuantity.temperature()) + " K, stable phases:");
listStablePhases(result);


function listStablePhases(result)
    stable_phases = result.get_stable_phases();
    for index = 1: length(stable_phases)
        phase = stable_phases{index};
        disp("Amount of " + phase + " = " + ...
            result.get_value_of("NP(" + phase + ")"));
    end
end